/*
 * Decompiled with CFR 0.152.
 */
package io.github.glytching.junit.extension.random;

import io.github.benas.randombeans.EnhancedRandomBuilder;
import io.github.benas.randombeans.api.EnhancedRandom;
import io.github.glytching.junit.extension.random.Random;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;
import org.junit.platform.commons.support.AnnotationSupport;

public class RandomBeansExtension
implements TestInstancePostProcessor,
ParameterResolver {
    private final EnhancedRandom random = EnhancedRandomBuilder.aNewEnhancedRandomBuilder().objectPoolSize(10).randomizationDepth(5).charset(Charset.forName("UTF-8")).stringLengthRange(5, 50).collectionSizeRange(1, 10).scanClasspathForConcreteTypes(true).overrideDefaultInitialization(false).build();

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return parameterContext.getParameter().getAnnotation(Random.class) != null;
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return this.resolve(parameterContext.getParameter().getType(), parameterContext.getParameter().getAnnotation(Random.class));
    }

    public void postProcessTestInstance(Object testInstance, ExtensionContext extensionContext) throws Exception {
        for (Field field : testInstance.getClass().getDeclaredFields()) {
            if (!AnnotationSupport.isAnnotated((AnnotatedElement)field, Random.class)) continue;
            Random annotation = field.getAnnotation(Random.class);
            Object randomObject = this.resolve(field.getType(), annotation);
            field.setAccessible(true);
            field.set(testInstance, randomObject);
        }
    }

    private Object resolve(Class<?> targetType, Random annotation) {
        if (targetType.isAssignableFrom(List.class) || targetType.isAssignableFrom(Collection.class)) {
            return this.random.objects(annotation.type(), annotation.size(), annotation.excludes()).collect(Collectors.toList());
        }
        if (targetType.isAssignableFrom(Set.class)) {
            return this.random.objects(annotation.type(), annotation.size(), annotation.excludes()).collect(Collectors.toSet());
        }
        if (targetType.isAssignableFrom(Stream.class)) {
            return this.random.objects(annotation.type(), annotation.size(), annotation.excludes());
        }
        return this.random.nextObject(targetType, annotation.excludes());
    }
}

