/*
 * Decompiled with CFR 0.152.
 */
package io.github.glytching.junit.extension.exception;

import io.github.glytching.junit.extension.exception.ExpectedException;
import io.github.glytching.junit.extension.util.ExtensionUtil;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestExecutionExceptionHandler;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.FunctionUtils;

public class ExpectedExceptionExtension
implements TestExecutionExceptionHandler,
AfterTestExecutionCallback {
    private static final String KEY = "exceptionWasHandled";
    private final Function<Throwable, String> function = Throwable::getMessage;

    public void handleTestExecutionException(ExtensionContext extensionContext, Throwable throwable) throws Throwable {
        ExpectedException annotation;
        Optional optional = AnnotationUtils.findAnnotation((Optional)extensionContext.getTestMethod(), ExpectedException.class);
        if (optional.isPresent() && (annotation = (ExpectedException)optional.get()).type().isAssignableFrom(throwable.getClass()) && FunctionUtils.where(this.function, this.getPredicate(annotation)).test(throwable)) {
            ExtensionUtil.getStore(extensionContext, this.getClass()).put((Object)KEY, (Object)true);
            return;
        }
        throw throwable;
    }

    public void afterTestExecution(ExtensionContext extensionContext) throws Exception {
        Boolean exceptionWasHandled = (Boolean)ExtensionUtil.getStore(extensionContext, this.getClass()).getOrComputeIfAbsent((Object)KEY, s -> false);
        if (!exceptionWasHandled.booleanValue() && !extensionContext.getExecutionException().isPresent()) {
            Assertions.fail((String)"Expected an exception but no exception was thrown!");
        }
    }

    private Predicate<String> getPredicate(ExpectedException annotation) {
        if (this.has(annotation.messageStartsWith())) {
            return s -> s.startsWith(annotation.messageStartsWith());
        }
        if (this.has(annotation.messageContains())) {
            return s -> s.contains(annotation.messageContains());
        }
        if (this.has(annotation.messageIs())) {
            return s -> s.equals(annotation.messageIs());
        }
        return s -> true;
    }

    private boolean has(String incoming) {
        return incoming != null && incoming.length() > 0;
    }
}

