/*
 * Decompiled with CFR 0.152.
 */
package io.github.glytching.junit.extension.folder;

import io.github.glytching.junit.extension.folder.TemporaryFolderException;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import org.junit.jupiter.api.extension.ExtensionContext;

public class TemporaryFolder
implements ExtensionContext.Store.CloseableResource {
    private static final String FILE_PREFIX = "junit";
    private static final String FILE_SUFFIX = ".tmp";
    private final File rootFolder;

    TemporaryFolder() {
        try {
            this.rootFolder = File.createTempFile(FILE_PREFIX, FILE_SUFFIX);
            Files.delete(this.rootFolder.toPath());
            Files.createDirectory(this.rootFolder.toPath(), new FileAttribute[0]);
        }
        catch (IOException ex) {
            throw new TemporaryFolderException("Failed to prepare root folder!", ex);
        }
    }

    public void close() throws Throwable {
        this.destroy();
    }

    public File getRoot() {
        return this.rootFolder;
    }

    public File createFile(String fileName) throws IOException {
        Path path = Paths.get(this.rootFolder.getPath(), fileName);
        return Files.createFile(path, new FileAttribute[0]).toFile();
    }

    public File createDirectory(String directoryName) {
        Path path = Paths.get(this.rootFolder.getPath(), directoryName);
        try {
            return Files.createDirectory(path, new FileAttribute[0]).toFile();
        }
        catch (IOException ex) {
            throw new TemporaryFolderException(String.format("Failed to create directory: '%s'", path.toString()), ex);
        }
    }

    void destroy() throws IOException {
        if (this.rootFolder.exists()) {
            Files.walkFileTree(this.rootFolder.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) throws IOException {
                    return this.delete(file);
                }

                @Override
                public FileVisitResult postVisitDirectory(Path directory, IOException exception) throws IOException {
                    return this.delete(directory);
                }

                private FileVisitResult delete(Path file) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }
            });
            if (this.rootFolder.exists()) {
                Files.delete(this.rootFolder.toPath());
            }
        }
    }
}

