/*
 * Decompiled with CFR 0.152.
 */
package io.github.gmazzo.gitversion;

import io.github.gmazzo.gitversion.GitVersionProducer;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.Collection;
import javax.inject.Inject;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.ValueSource;
import org.gradle.api.provider.ValueSourceParameters;
import org.gradle.process.ExecOperations;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b&\u0018\u0000 #2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0002\"#B\u0011\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0010\u001a\u00020\u0002H\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00022\b\b\u0002\u0010\u0012\u001a\u00020\u0002J\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u00022\b\b\u0002\u0010\u0012\u001a\u00020\u00022\b\b\u0002\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0012\u001a\u00020\u0002J7\u0010\u001b\u001a\u0004\u0018\u00010\u00022\u0012\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u001d\"\u00020\u00022\u0014\b\u0002\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020 0\u001f\u00a2\u0006\u0002\u0010!R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\u00020\u00028FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u0015\u0010\u0018\u001a\u00020\u0002*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006$"}, d2={"Lio/github/gmazzo/gitversion/GitVersionValueSource;", "Lorg/gradle/api/provider/ValueSource;", "", "Lio/github/gmazzo/gitversion/GitVersionValueSource$Params;", "execOperations", "Lorg/gradle/process/ExecOperations;", "<init>", "(Lorg/gradle/process/ExecOperations;)V", "logger", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "candidate", "getCandidate", "()Ljava/lang/String;", "candidate$delegate", "Lkotlin/Lazy;", "obtain", "exactTag", "tagPrefix", "closestTag", "warnIfMissing", "", "tagsCount", "", "nextSnapshot", "getNextSnapshot", "(Ljava/lang/String;)Ljava/lang/String;", "command", "args", "", "onError", "Lkotlin/Function1;", "", "([Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Ljava/lang/String;", "Params", "Companion", "plugin"})
@SourceDebugExtension(value={"SMAP\nGitVersionValueSource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitVersionValueSource.kt\nio/github/gmazzo/gitversion/GitVersionValueSource\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,106:1\n1#2:107\n*E\n"})
public abstract class GitVersionValueSource
implements ValueSource<String, Params> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExecOperations execOperations;
    private final Logger logger;
    @NotNull
    private final Lazy candidate$delegate;
    @NotNull
    public static final String SNAPSHOT_SUFFIX = "-SNAPSHOT";

    @Inject
    public GitVersionValueSource(@NotNull ExecOperations execOperations) {
        Intrinsics.checkNotNullParameter((Object)execOperations, (String)"execOperations");
        this.execOperations = execOperations;
        this.logger = Logging.getLogger(GitVersionValueSource.class);
        this.candidate$delegate = LazyKt.lazy(() -> GitVersionValueSource.candidate_delegate$lambda$2(this));
    }

    @NotNull
    public final String getCandidate() {
        Lazy lazy = this.candidate$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (String)object;
    }

    @NotNull
    public String obtain() {
        Object object = (GitVersionProducer)((Params)this.getParameters()).getVersionProducer().getOrNull();
        if (object == null || (object = object.produceVersion(this)) == null) {
            object = this.getCandidate();
        }
        return object;
    }

    @Nullable
    public final String exactTag(@NotNull String tagPrefix2) {
        Intrinsics.checkNotNullParameter((Object)tagPrefix2, (String)"tagPrefix");
        String[] stringArray = new String[]{"git", "describe", "--tags", "--match", tagPrefix2 + "*", "--exact-match"};
        return GitVersionValueSource.command$default(this, stringArray, null, 2, null);
    }

    public static /* synthetic */ String exactTag$default(GitVersionValueSource gitVersionValueSource, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: exactTag");
        }
        if ((n & 1) != 0) {
            string = (String)((Params)gitVersionValueSource.getParameters()).getTagPrefix().getOrElse((Object)"");
        }
        return gitVersionValueSource.exactTag(string);
    }

    @Nullable
    public final String closestTag(@NotNull String tagPrefix2, boolean warnIfMissing) {
        Intrinsics.checkNotNullParameter((Object)tagPrefix2, (String)"tagPrefix");
        String[] stringArray = new String[]{"git", "describe", "--tags", "--match", tagPrefix2 + "*", "--abbrev=0"};
        return this.command(stringArray, (Function1<? super String, Unit>)((Function1)arg_0 -> GitVersionValueSource.closestTag$lambda$3(warnIfMissing, this, arg_0)));
    }

    public static /* synthetic */ String closestTag$default(GitVersionValueSource gitVersionValueSource, String string, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: closestTag");
        }
        if ((n & 1) != 0) {
            string = (String)((Params)gitVersionValueSource.getParameters()).getTagPrefix().getOrElse((Object)"");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        return gitVersionValueSource.closestTag(string, bl);
    }

    public final int tagsCount(@NotNull String tagPrefix2) {
        Intrinsics.checkNotNullParameter((Object)tagPrefix2, (String)"tagPrefix");
        String[] stringArray = new String[]{"git", "tag", "--merged", "HEAD", tagPrefix2 + "*"};
        String string = GitVersionValueSource.command$default(this, stringArray, null, 2, null);
        Intrinsics.checkNotNull((Object)string);
        return ((Collection)StringsKt.lines((CharSequence)string)).size();
    }

    public static /* synthetic */ int tagsCount$default(GitVersionValueSource gitVersionValueSource, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: tagsCount");
        }
        if ((n & 1) != 0) {
            string = (String)((Params)gitVersionValueSource.getParameters()).getTagPrefix().getOrElse((Object)"");
        }
        return gitVersionValueSource.tagsCount(string);
    }

    @NotNull
    public final String getNextSnapshot(@NotNull String $this$nextSnapshot) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$nextSnapshot, (String)"<this>");
        if (StringsKt.endsWith$default((String)$this$nextSnapshot, (String)SNAPSHOT_SUFFIX, (boolean)false, (int)2, null)) {
            object = $this$nextSnapshot;
        } else {
            MatchResult match = new Regex("(\\d+)\\.(\\d+)\\.(\\d+)(\\.\\d+)?(.*)$").matchEntire((CharSequence)$this$nextSnapshot);
            if (match == null) {
                object = $this$nextSnapshot + SNAPSHOT_SUFFIX;
            } else {
                StringBuilder stringBuilder;
                MatchResult.Destructured destructured = match.getDestructured();
                boolean bl = false;
                String major = (String)destructured.getMatch().getGroupValues().get(1);
                String minor = (String)destructured.getMatch().getGroupValues().get(2);
                String build = (String)destructured.getMatch().getGroupValues().get(4);
                String suffix = (String)destructured.getMatch().getGroupValues().get(5);
                StringBuilder $this$_get_nextSnapshot__u24lambda_u245_u24lambda_u244 = stringBuilder = new StringBuilder();
                boolean bl2 = false;
                $this$_get_nextSnapshot__u24lambda_u245_u24lambda_u244.append(major);
                $this$_get_nextSnapshot__u24lambda_u245_u24lambda_u244.append('.');
                $this$_get_nextSnapshot__u24lambda_u245_u24lambda_u244.append(Integer.parseInt(minor) + 1);
                $this$_get_nextSnapshot__u24lambda_u245_u24lambda_u244.append(".0");
                if (((CharSequence)build).length() > 0) {
                    $this$_get_nextSnapshot__u24lambda_u245_u24lambda_u244.append(".0");
                }
                $this$_get_nextSnapshot__u24lambda_u245_u24lambda_u244.append(SNAPSHOT_SUFFIX);
                $this$_get_nextSnapshot__u24lambda_u245_u24lambda_u244.append(suffix);
                String string = stringBuilder.toString();
                object = string;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            }
        }
        return object;
    }

    @Nullable
    public final String command(@NotNull String[] args, @NotNull Function1<? super String, Unit> onError) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Intrinsics.checkNotNullParameter(onError, (String)"onError");
        ByteArrayOutputStream stdout = new ByteArrayOutputStream();
        ByteArrayOutputStream stderr = new ByteArrayOutputStream();
        int exitValue = this.execOperations.exec(arg_0 -> GitVersionValueSource.command$lambda$8(arg_0 -> GitVersionValueSource.command$lambda$7(this, args, stdout, stderr, arg_0), arg_0)).getExitValue();
        if (exitValue == 0) {
            String string = stdout.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return ((Object)StringsKt.trim((CharSequence)string)).toString();
        }
        String string = stderr.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        onError.invoke((Object)((Object)StringsKt.trim((CharSequence)string)).toString());
        return null;
    }

    public static /* synthetic */ String command$default(GitVersionValueSource gitVersionValueSource, String[] stringArray, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: command");
        }
        if ((n & 2) != 0) {
            function1 = GitVersionValueSource::command$lambda$6;
        }
        return gitVersionValueSource.command(stringArray, (Function1<? super String, Unit>)function1);
    }

    private static final String candidate_delegate$lambda$2(GitVersionValueSource this$0) {
        String string;
        String version2;
        Object snapshot;
        block9: {
            String string2;
            block8: {
                String tag;
                Params $this$candidate_delegate_u24lambda_u242_u24lambda_u241 = (Params)this$0.getParameters();
                boolean bl = false;
                snapshot = null;
                snapshot = $this$candidate_delegate_u24lambda_u242_u24lambda_u241.getForceSnapshot().get();
                String prefix = (String)$this$candidate_delegate_u24lambda_u242_u24lambda_u241.getTagPrefix().getOrElse((Object)"");
                String string3 = GitVersionValueSource.exactTag$default(this$0, null, 1, null);
                if (string3 == null) {
                    String string4 = GitVersionValueSource.closestTag$default(this$0, null, false, 3, null);
                    if (string4 != null) {
                        String string5;
                        String it = string5 = string4;
                        boolean bl2 = false;
                        snapshot = true;
                        string3 = string5;
                    } else {
                        string3 = null;
                    }
                }
                if ((string2 = (tag = string3)) == null) break block8;
                Intrinsics.checkNotNull((Object)prefix);
                if ((string2 = StringsKt.removePrefix((String)string2, (CharSequence)prefix)) != null) break block9;
            }
            string2 = version2 = (String)((Params)this$0.getParameters()).getInitialVersion().get();
        }
        if (((Boolean)snapshot).booleanValue()) {
            Intrinsics.checkNotNull((Object)version2);
            string = this$0.getNextSnapshot(version2);
        } else {
            string = version2;
        }
        return string;
    }

    private static final Unit closestTag$lambda$3(boolean $warnIfMissing, GitVersionValueSource this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if ($warnIfMissing) {
            this$0.logger.warn("failed to compute git version (no tags yet?): " + it);
        }
        return Unit.INSTANCE;
    }

    private static final Unit command$lambda$6(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    private static final Unit command$lambda$7(GitVersionValueSource this$0, String[] $args, ByteArrayOutputStream $stdout, ByteArrayOutputStream $stderr, ExecSpec $this$exec) {
        File file = (File)((Params)this$0.getParameters()).getGitRoot().getAsFile().getOrNull();
        if (file != null) {
            File p0 = file;
            boolean bl = false;
            $this$exec.workingDir((Object)p0);
        }
        $this$exec.setCommandLine(ArraysKt.toList((Object[])$args));
        $this$exec.setIgnoreExitValue(true);
        $this$exec.setStandardOutput((OutputStream)$stdout);
        $this$exec.setErrorOutput((OutputStream)$stderr);
        return Unit.INSTANCE;
    }

    private static final void command$lambda$8(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/github/gmazzo/gitversion/GitVersionValueSource$Companion;", "", "<init>", "()V", "SNAPSHOT_SUFFIX", "", "plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0018\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\nR\u0018\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\n\u00a8\u0006\u0013"}, d2={"Lio/github/gmazzo/gitversion/GitVersionValueSource$Params;", "Lorg/gradle/api/provider/ValueSourceParameters;", "gitRoot", "Lorg/gradle/api/file/DirectoryProperty;", "getGitRoot", "()Lorg/gradle/api/file/DirectoryProperty;", "tagPrefix", "Lorg/gradle/api/provider/Property;", "", "getTagPrefix", "()Lorg/gradle/api/provider/Property;", "initialVersion", "getInitialVersion", "forceSnapshot", "", "getForceSnapshot", "versionProducer", "Lio/github/gmazzo/gitversion/GitVersionProducer;", "getVersionProducer", "plugin"})
    public static interface Params
    extends ValueSourceParameters {
        @NotNull
        public DirectoryProperty getGitRoot();

        @NotNull
        public Property<String> getTagPrefix();

        @NotNull
        public Property<String> getInitialVersion();

        @NotNull
        public Property<Boolean> getForceSnapshot();

        @NotNull
        public Property<GitVersionProducer> getVersionProducer();
    }
}

