/*
 * Decompiled with CFR 0.152.
 */
package io.github.gmazzo.publications.report;

import io.github.gmazzo.publications.report.ReportPublication;
import io.github.gmazzo.publications.report.ReportPublicationsFlowAction;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.flow.FlowAction;
import org.gradle.api.flow.FlowParameters;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.tasks.Input;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.logging.text.StyledTextOutputFactory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J&\u0010\f\u001a\u00020\n*\u00020\r2\u0018\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00110\u000fH\u0002R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/github/gmazzo/publications/report/ReportPublicationsFlowAction;", "Lorg/gradle/api/flow/FlowAction;", "Lio/github/gmazzo/publications/report/ReportPublicationsFlowAction$Params;", "<init>", "()V", "publicationsComparator", "Ljava/util/Comparator;", "Lio/github/gmazzo/publications/report/ReportPublication;", "Lkotlin/Comparator;", "execute", "", "parameters", "report", "Lorg/gradle/internal/logging/text/StyledTextOutput;", "publications", "Ljava/util/TreeMap;", "Lio/github/gmazzo/publications/report/ReportPublication$Repository;", "Ljava/util/TreeSet;", "Params", "plugin"})
@SourceDebugExtension(value={"SMAP\nReportPublicationsFlowAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReportPublicationsFlowAction.kt\nio/github/gmazzo/publications/report/ReportPublicationsFlowAction\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,82:1\n216#2,2:83\n216#2:85\n217#2:88\n1863#3,2:86\n1#4:89\n*S KotlinDebug\n*F\n+ 1 ReportPublicationsFlowAction.kt\nio/github/gmazzo/publications/report/ReportPublicationsFlowAction\n*L\n24#1:83,2\n44#1:85\n44#1:88\n54#1:86,2\n*E\n"})
public abstract class ReportPublicationsFlowAction
implements FlowAction<Params> {
    @NotNull
    private final Comparator<ReportPublication> publicationsComparator;

    public ReportPublicationsFlowAction() {
        Function1[] function1Array = new Function1[]{publicationsComparator.1.INSTANCE, publicationsComparator.2.INSTANCE, publicationsComparator.3.INSTANCE};
        this.publicationsComparator = ComparisonsKt.compareBy((Function1[])function1Array);
    }

    public void execute(@NotNull Params parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        StyledTextOutput logger = parameters.getStyledTextOutputFactory().create(ReportPublication.class);
        TreeMap<ReportPublication.Repository, TreeSet<ReportPublication>> publications = new TreeMap<ReportPublication.Repository, TreeSet<ReportPublication>>(new Comparator(){

            public final int compare(T a, T b) {
                ReportPublication.Repository p0 = (ReportPublication.Repository)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)p0.getValue());
                p0 = (ReportPublication.Repository)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)p0.getValue())));
            }
        });
        Map outcomes = (Map)parameters.getOutcomes().get();
        Object object = parameters.getPublications().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        Map $this$forEach$iv = (Map)object;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            String path = (String)entry.getKey();
            ReportPublication pub = (ReportPublication)entry.getValue();
            ReportPublication.Outcome outcome = (ReportPublication.Outcome)((Object)outcomes.get(path));
            if (outcome == null) {
                outcome = pub.getOutcome();
            }
            ReportPublication.Outcome outcome2 = outcome;
            publications.compute(pub.getRepository(), (arg_0, arg_1) -> ReportPublicationsFlowAction.execute$lambda$3$lambda$2((arg_0, arg_1) -> ReportPublicationsFlowAction.execute$lambda$3$lambda$1(this, pub, outcome2, arg_0, arg_1), arg_0, arg_1));
        }
        Intrinsics.checkNotNull((Object)logger);
        this.report(logger, publications);
    }

    private final void report(StyledTextOutput $this$report, TreeMap<ReportPublication.Repository, TreeSet<ReportPublication>> publications) {
        StyledTextOutput header = $this$report.withStyle(StyledTextOutput.Style.Header);
        StyledTextOutput description = $this$report.withStyle(StyledTextOutput.Style.Description);
        StyledTextOutput identifier = $this$report.withStyle(StyledTextOutput.Style.Identifier);
        StyledTextOutput info = $this$report.withStyle(StyledTextOutput.Style.Info);
        StyledTextOutput failure = $this$report.withStyle(StyledTextOutput.Style.Failure);
        StyledTextOutput failureHeader = $this$report.withStyle(StyledTextOutput.Style.FailureHeader);
        $this$report.println();
        Map $this$forEach$iv = publications;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            ReportPublication.Repository repository = (ReportPublication.Repository)entry.getKey();
            TreeSet publications2 = (TreeSet)entry.getValue();
            $this$report.text((Object)"The following artifacts were published to ");
            header.text((Object)repository.getName());
            if (!StringsKt.isBlank((CharSequence)repository.getValue())) {
                $this$report.text((Object)"(");
                description.text((Object)repository.getValue());
                $this$report.text((Object)")");
            }
            $this$report.println((Object)":");
            Iterable $this$forEach$iv2 = publications2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                ReportPublication it = (ReportPublication)element$iv2;
                boolean bl2 = false;
                $this$report.text((Object)" - ");
                identifier.text((Object)it.getGroupId());
                $this$report.text((Object)(":" + it.getArtifactId() + ":"));
                info.text((Object)it.getVersion());
                failure.text((Object)CollectionsKt.joinToString$default((Iterable)it.getArtifacts(), (CharSequence)", ", (CharSequence)" [", (CharSequence)"]", (int)0, null, null, (int)56, null));
                if (it.getOutcome() != ReportPublication.Outcome.Published) {
                    String string = it.getOutcome().name().toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                    failureHeader.text((Object)(" (" + string + ")"));
                }
                $this$report.println();
            }
        }
    }

    private static final TreeSet execute$lambda$3$lambda$1(ReportPublicationsFlowAction this$0, ReportPublication $pub, ReportPublication.Outcome $outcome, ReportPublication.Repository repository, TreeSet set) {
        TreeSet treeSet;
        TreeSet treeSet2 = set;
        if (treeSet2 == null) {
            treeSet2 = new TreeSet<ReportPublication>(this$0.publicationsComparator);
        }
        TreeSet $this$execute_u24lambda_u243_u24lambda_u241_u24lambda_u240 = treeSet = treeSet2;
        boolean bl = false;
        $this$execute_u24lambda_u243_u24lambda_u241_u24lambda_u240.add(ReportPublication.copy$default($pub, null, null, null, null, $outcome, null, 47, null));
        return treeSet;
    }

    private static final TreeSet execute$lambda$3$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        return (TreeSet)$tmp0.invoke(p0, p1);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001R\u0014\u0010\u0002\u001a\u00020\u00038gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R \u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00078gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR \u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\r0\u00078gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lio/github/gmazzo/publications/report/ReportPublicationsFlowAction$Params;", "Lorg/gradle/api/flow/FlowParameters;", "styledTextOutputFactory", "Lorg/gradle/internal/logging/text/StyledTextOutputFactory;", "getStyledTextOutputFactory", "()Lorg/gradle/internal/logging/text/StyledTextOutputFactory;", "publications", "Lorg/gradle/api/provider/MapProperty;", "", "Lio/github/gmazzo/publications/report/ReportPublication;", "getPublications", "()Lorg/gradle/api/provider/MapProperty;", "outcomes", "Lio/github/gmazzo/publications/report/ReportPublication$Outcome;", "getOutcomes", "plugin"})
    public static interface Params
    extends FlowParameters {
        @Inject
        @NotNull
        public StyledTextOutputFactory getStyledTextOutputFactory();

        @Input
        @NotNull
        public MapProperty<String, ReportPublication> getPublications();

        @Input
        @NotNull
        public MapProperty<String, ReportPublication.Outcome> getOutcomes();
    }
}

