/*
 * Decompiled with CFR 0.152.
 */
package com.goetschalckx.spring.logging.web;

import com.goetschalckx.spring.logging.web.LogArgUtils;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.StringUtils;

public class LogEventContext {
    private final Map<String, String> args = new HashMap<String, String>(8);
    private final boolean includeBody;
    private final String spanKind;
    private final String spanId;
    private final String method;
    private final String url;

    public LogEventContext(boolean includeBody, String spanKind, String spanId, String method, String url) {
        this.includeBody = includeBody;
        this.spanKind = spanKind;
        this.spanId = spanId;
        this.method = method;
        this.url = url;
        LogArgUtils.addIfValuePresent(this.args, "span.kind", spanKind);
        LogArgUtils.addIfValuePresent(this.args, "span.id", spanId);
        LogArgUtils.addIfValuePresent(this.args, "http.method", method);
        LogArgUtils.addIfValuePresent(this.args, "http.url", url);
    }

    public boolean getIncludeBody() {
        return this.includeBody;
    }

    public String getSpanKind() {
        return this.spanKind;
    }

    public String getSpanId() {
        return this.spanId;
    }

    public String getMethod() {
        return this.method;
    }

    public String getUrl() {
        return this.url;
    }

    public Map<String, String> getArgs() {
        return this.args;
    }

    public void addArgIfPresent(String key, String value) {
        if (StringUtils.isEmpty((Object)key) || StringUtils.isEmpty((Object)value)) {
            return;
        }
        this.args.put(key, value);
    }
}

