/*
 * Decompiled with CFR 0.152.
 */
package com.goetschalckx.spring.logging.web.client;

import com.goetschalckx.spring.logging.web.LogEventContext;
import com.goetschalckx.spring.logging.web.client.ClientLogger;
import com.goetschalckx.spring.logging.web.span.SpanIdGenerator;
import com.goetschalckx.spring.logging.web.span.SpanType;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

public class ClientHttpRequestLoggingInterceptor
implements ClientHttpRequestInterceptor {
    private static final Logger log = LoggerFactory.getLogger(ClientHttpRequestLoggingInterceptor.class);
    private static final String SPAN_KIND_CLIENT = SpanType.CLIENT.logValue();
    private final boolean includeBody;
    private final ClientLogger clientLogger;
    private final SpanIdGenerator spanIdGenerator;

    public ClientHttpRequestLoggingInterceptor(boolean includeBody, ClientLogger clientLogger, SpanIdGenerator spanIdGenerator) {
        this.includeBody = includeBody;
        this.clientLogger = clientLogger;
        this.spanIdGenerator = spanIdGenerator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        if (!log.isInfoEnabled()) {
            return execution.execute(request, body);
        }
        String spanId = this.spanIdGenerator.spanId();
        MDC.put((String)"span.id", (String)spanId);
        MDC.put((String)"span.kind", (String)SPAN_KIND_CLIENT);
        try {
            ClientHttpResponse clientHttpResponse = this.log(request, body, execution, spanId);
            return clientHttpResponse;
        }
        finally {
            MDC.remove((String)"span.id");
            MDC.remove((String)"span.kind");
        }
    }

    private ClientHttpResponse log(HttpRequest request, byte[] body, ClientHttpRequestExecution execution, String spanId) throws IOException {
        String method = request.getMethod().name();
        String url = request.getURI().toString();
        LogEventContext context = new LogEventContext(this.includeBody, SPAN_KIND_CLIENT, spanId, method, url);
        this.clientLogger.logRequest(context, request, body);
        ClientHttpResponse response = execution.execute(request, body);
        this.clientLogger.logResponse(context, response);
        return response;
    }
}

