/*
 * Decompiled with CFR 0.152.
 */
package com.goetschalckx.spring.logging.web.client;

import com.goetschalckx.spring.logging.web.LogArgUtils;
import com.goetschalckx.spring.logging.web.LogEventContext;
import com.goetschalckx.spring.logging.web.client.ClientLoggingUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import net.logstash.logback.marker.Markers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.StreamUtils;

public class ClientLogger {
    private static final Logger log = LoggerFactory.getLogger(ClientLogger.class);

    public void logResponse(LogEventContext context, ClientHttpResponse response) {
        String statusCode = ClientLoggingUtils.getStatusCode(response);
        LogArgUtils.addIfValuePresent(context.getArgs(), "http.status", statusCode);
        LogArgUtils.addHeaders(context.getArgs(), response.getHeaders());
        if (context.getIncludeBody()) {
            String responseBody;
            try {
                responseBody = StreamUtils.copyToString((InputStream)response.getBody(), (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                log.error("IOException during copyToString");
                responseBody = "[unknown]";
            }
            log.info((Marker)Markers.appendEntries(context.getArgs()), "Inbound Message\n----------------------------\nSpan Kind: {}\nSpan ID: {}\nMethod: {}\nURL: {}\nStatus Code: {}\nHeaders: {}\nPayload: {}\n--------------------------------------", new Object[]{context.getSpanKind(), context.getSpanId(), context.getMethod(), context.getUrl(), statusCode, response.getHeaders(), responseBody});
        } else {
            log.info((Marker)Markers.appendEntries(context.getArgs()), "Inbound Message\n--------------------------------------\nSpan Kind: {}\nSpan ID: {}\nMethod: {}\nURL: {}\nStatus Code: {}\nHeaders: {}\n--------------------------------------", new Object[]{context.getSpanKind(), context.getSpanId(), context.getMethod(), context.getUrl(), statusCode, response.getHeaders()});
        }
    }

    public void logRequest(LogEventContext context, HttpRequest request, byte[] body) {
        LogArgUtils.addHeaders(context.getArgs(), request.getHeaders());
        if (context.getIncludeBody()) {
            log.info((Marker)Markers.appendEntries(context.getArgs()), "Outbound Message\n--------------------------------------\nSpan Kind: {}\nSpan ID: {}\nMethod: {}\nURL: {}\nHeaders: {}\nPayload: {}\n--------------------------------------", new Object[]{context.getSpanKind(), context.getSpanId(), context.getMethod(), context.getUrl(), request.getHeaders(), new String(body, StandardCharsets.UTF_8)});
        } else {
            log.info((Marker)Markers.appendEntries(context.getArgs()), "Outbound Message\n--------------------------------------\nSpan Kind: {}\nSpan ID: {}\nMethod: {}\nURL: {}\nHeaders: {}\n--------------------------------------", new Object[]{context.getSpanKind(), context.getSpanId(), context.getMethod(), context.getUrl(), request.getHeaders()});
        }
    }
}

