/*
 * Decompiled with CFR 0.152.
 */
package com.goetschalckx.spring.logging.web.client;

import com.goetschalckx.spring.logging.web.client.ClientHttpRequestLoggingInterceptor;
import com.goetschalckx.spring.logging.web.client.ClientLogger;
import com.goetschalckx.spring.logging.web.client.LoggingInterceptorCustomizer;
import com.goetschalckx.spring.logging.web.span.SpanIdGenerator;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;

@Configuration
@ConditionalOnProperty(prefix="logging.web.client", name={"enabled"}, havingValue="true")
public class ClientLoggingConfig {
    @Value(value="${logging.web.client.include-body:false}")
    private boolean includeBody = false;

    @Bean
    public ClientHttpRequestFactory clientHttpRequestFactory() {
        SimpleClientHttpRequestFactory simpleClientHttpRequestFactory = new SimpleClientHttpRequestFactory();
        simpleClientHttpRequestFactory.setOutputStreaming(!this.includeBody);
        simpleClientHttpRequestFactory.setBufferRequestBody(!this.includeBody);
        return simpleClientHttpRequestFactory;
    }

    @Bean
    public LoggingInterceptorCustomizer loggingInterceptorCustomizer(ClientHttpRequestLoggingInterceptor clientHttpRequestLoggingInterceptor, ClientHttpRequestFactory clientHttpRequestFactory) {
        return new LoggingInterceptorCustomizer(clientHttpRequestLoggingInterceptor, clientHttpRequestFactory, this.includeBody);
    }

    @Bean
    @ConditionalOnMissingBean
    public ClientLogger clientLogger() {
        return new ClientLogger();
    }

    @Bean
    @ConditionalOnMissingBean
    public ClientHttpRequestLoggingInterceptor clientHttpRequestLoggingInterceptor(ClientLogger clientLogger, SpanIdGenerator spanIdGenerator) {
        return new ClientHttpRequestLoggingInterceptor(this.includeBody, clientLogger, spanIdGenerator);
    }
}

