/*
 * Decompiled with CFR 0.152.
 */
package com.goetschalckx.spring.logging.web.client;

import com.goetschalckx.spring.logging.web.client.ClientHttpRequestLoggingInterceptor;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.http.client.BufferingClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

public class LoggingInterceptorCustomizer
implements RestTemplateCustomizer {
    private final ClientHttpRequestLoggingInterceptor clientHttpRequestLoggingInterceptor;
    private final ClientHttpRequestFactory requestFactory;
    private final boolean logResponseBody;

    public LoggingInterceptorCustomizer(ClientHttpRequestLoggingInterceptor clientHttpRequestLoggingInterceptor, ClientHttpRequestFactory requestFactory, boolean logResponseBody) {
        this.clientHttpRequestLoggingInterceptor = clientHttpRequestLoggingInterceptor;
        this.requestFactory = requestFactory;
        this.logResponseBody = logResponseBody;
    }

    public void customize(RestTemplate restTemplate) {
        restTemplate.getInterceptors().add(this.clientHttpRequestLoggingInterceptor);
        if (this.logResponseBody) {
            BufferingClientHttpRequestFactory bufferingClientHttpRequestFactory = new BufferingClientHttpRequestFactory(this.requestFactory);
            restTemplate.setRequestFactory((ClientHttpRequestFactory)bufferingClientHttpRequestFactory);
        }
    }
}

