/*
 * Decompiled with CFR 0.152.
 */
package com.goetschalckx.spring.logging.web.server;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class MultiReadHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private byte[] requestBody = new byte[0];
    private boolean bufferFilled = false;

    public MultiReadHttpServletRequestWrapper(HttpServletRequest request) {
        super(request);
    }

    public byte[] getRequestBody() throws IOException {
        int bytesRead;
        if (this.bufferFilled) {
            return Arrays.copyOf(this.requestBody, this.requestBody.length);
        }
        ServletInputStream inputStream = super.getInputStream();
        byte[] buffer = new byte[102400];
        while ((bytesRead = inputStream.read(buffer)) != -1) {
            this.requestBody = MultiReadHttpServletRequestWrapper.concat(this.requestBody, Arrays.copyOfRange(buffer, 0, bytesRead));
        }
        this.bufferFilled = true;
        return this.requestBody;
    }

    public ServletInputStream getInputStream() throws IOException {
        return new ByteArrayServletInputStream(this.getRequestBody());
    }

    public static byte[] concat(byte[] ... arrays) {
        int length = 0;
        for (byte[] array : arrays) {
            length += array.length;
        }
        byte[] result = new byte[length];
        int pos = 0;
        for (byte[] array : arrays) {
            System.arraycopy(array, 0, result, pos, array.length);
            pos += array.length;
        }
        return result;
    }

    private static class ByteArrayServletInputStream
    extends ServletInputStream {
        private ByteArrayInputStream buffer;

        public ByteArrayServletInputStream(byte[] contents) {
            this.buffer = new ByteArrayInputStream(contents);
        }

        public int read() {
            return this.buffer.read();
        }

        public boolean isFinished() {
            return this.buffer.available() == 0;
        }

        public boolean isReady() {
            return true;
        }

        public void setReadListener(ReadListener listener) {
            throw new UnsupportedOperationException("CustomServletInputStream.setReadListener is not implemented");
        }
    }
}

