/*
 * Decompiled with CFR 0.152.
 */
package com.goetschalckx.spring.logging.web.server;

import com.goetschalckx.spring.logging.web.LogEventContext;
import com.goetschalckx.spring.logging.web.server.MultiReadHttpServletRequestWrapper;
import com.goetschalckx.spring.logging.web.server.ServerLogger;
import com.goetschalckx.spring.logging.web.span.SpanIdGenerator;
import com.goetschalckx.spring.logging.web.span.SpanType;
import java.io.IOException;
import java.util.concurrent.ThreadLocalRandom;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.slf4j.MDC;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.util.ContentCachingResponseWrapper;

public class RequestLoggingFilter
extends OncePerRequestFilter {
    private static final String SPAN_KIND_SERVER = SpanType.SERVER.logValue();
    private final boolean includeBody;
    private final ServerLogger serverLogger;
    private final SpanIdGenerator spanIdGenerator;

    public RequestLoggingFilter(boolean includeBody, ServerLogger serverLogger, SpanIdGenerator spanIdGenerator) {
        this.includeBody = includeBody;
        this.serverLogger = serverLogger;
        this.spanIdGenerator = spanIdGenerator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String spanId = this.spanIdGenerator.spanId();
        MDC.put((String)"span.id", (String)spanId);
        MDC.put((String)"span.kind", (String)SPAN_KIND_SERVER);
        try {
            this.doFilterInternalInternal(request, response, filterChain, spanId);
        }
        finally {
            MDC.remove((String)"span.id");
            MDC.remove((String)"span.kind");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFilterInternalInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain, String spanId) throws IOException, ServletException {
        boolean isFirstRequest = !this.isAsyncDispatch(request);
        Object requestToUse = request;
        if (this.includeBody && isFirstRequest && !(request instanceof MultiReadHttpServletRequestWrapper)) {
            requestToUse = new MultiReadHttpServletRequestWrapper(request);
        }
        HttpServletResponse responseToUse = response;
        if (this.includeBody && !(response instanceof ContentCachingResponseWrapper)) {
            responseToUse = new ContentCachingResponseWrapper(response);
        } else if (!(response instanceof HttpServletResponseWrapper)) {
            responseToUse = new HttpServletResponseWrapper(response);
        } else {
            int n = 42;
        }
        try {
            filterChain.doFilter((ServletRequest)requestToUse, (ServletResponse)responseToUse);
        }
        finally {
            this.internalInternalFinally(spanId, (HttpServletRequest)requestToUse, responseToUse);
        }
    }

    private void internalInternalFinally(String spanId, HttpServletRequest request, HttpServletResponse response) {
        if (!this.isAsyncStarted(request)) {
            String method = request.getMethod();
            String url = request.getRequestURL().toString();
            LogEventContext requestContext = new LogEventContext(this.includeBody, SpanType.SERVER.logValue(), spanId, method, url);
            requestContext.getArgs().put("rnd", Integer.toString(ThreadLocalRandom.current().nextInt(1, 5)));
            this.serverLogger.logRequest(requestContext, request);
            LogEventContext responseContext = new LogEventContext(this.includeBody, SpanType.SERVER.logValue(), spanId, method, url);
            responseContext.getArgs().put("rnd", Integer.toString(ThreadLocalRandom.current().nextInt(1, 5)));
            this.serverLogger.logResponse(responseContext, response);
        }
    }
}

