/*
 * Decompiled with CFR 0.152.
 */
package com.goetschalckx.spring.logging.web.server;

import com.goetschalckx.spring.logging.web.server.MultiReadHttpServletRequestWrapper;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.web.util.WebUtils;

public class RequestUtils {
    private static Logger log = LoggerFactory.getLogger(RequestUtils.class);

    public static String getRequestBody(HttpServletRequest request, int maxPayloadLength) {
        String requestBody;
        block6: {
            if (request == null) {
                return null;
            }
            requestBody = null;
            MultiReadHttpServletRequestWrapper requestWrapper = (MultiReadHttpServletRequestWrapper)((Object)WebUtils.getNativeRequest((ServletRequest)request, MultiReadHttpServletRequestWrapper.class));
            if (requestWrapper != null) {
                try {
                    String payload;
                    byte[] buf = requestWrapper.getRequestBody();
                    if (buf.length <= 0) break block6;
                    int length = Math.min(buf.length, maxPayloadLength);
                    try {
                        payload = new String(buf, 0, length, requestWrapper.getCharacterEncoding());
                    }
                    catch (UnsupportedEncodingException ex) {
                        payload = "[unknown]";
                    }
                    requestBody = payload;
                }
                catch (IOException e) {
                    log.error("IOException during getRequestBody()", (Throwable)e);
                }
            }
        }
        return requestBody;
    }

    public static HttpHeaders getRequestHeaders(HttpServletRequest request) {
        if (request == null) {
            return null;
        }
        Enumeration names = request.getHeaderNames();
        HttpHeaders headers = new HttpHeaders();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Enumeration values = request.getHeaders(name);
            while (values.hasMoreElements()) {
                String value = (String)values.nextElement();
                headers.add(name, value);
            }
        }
        return headers;
    }
}

