/*
 * Decompiled with CFR 0.152.
 */
package com.goetschalckx.spring.logging.web.server;

import com.goetschalckx.spring.logging.web.LogArgUtils;
import com.goetschalckx.spring.logging.web.LogEventContext;
import com.goetschalckx.spring.logging.web.server.RequestUtils;
import com.goetschalckx.spring.logging.web.server.ResponseUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import net.logstash.logback.marker.Markers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.springframework.http.HttpHeaders;

public class ServerLogger {
    private static Logger log = LoggerFactory.getLogger(ServerLogger.class);
    private static final int DEFAULT_MAX_PAYLOAD_LENGTH = 1024;

    public void logResponse(LogEventContext context, HttpServletResponse response) {
        int status = response.getStatus();
        context.getArgs().put("http.status", Integer.toString(status));
        if (context.getIncludeBody()) {
            String responseBody = ResponseUtils.getResponseBody(response);
            HttpHeaders httpHeaders = ResponseUtils.getResponseHeaders(response);
            LogArgUtils.addHeaders(context.getArgs(), httpHeaders);
            log.info((Marker)Markers.appendEntries(context.getArgs()), "Outbound Message\n--------------------------------------\nSpan Kind: {}\nSpan ID: {}\nMethod: {}\nURL: {}\nStatus Code: {}\nHeaders: {}\nPayload: {}\n--------------------------------------", new Object[]{context.getSpanKind(), context.getSpanId(), context.getMethod(), context.getUrl(), status, httpHeaders, responseBody});
        } else {
            HttpServletResponseWrapper responseWrapper = ResponseUtils.getResponseWrapper(response);
            HttpHeaders httpHeaders = ResponseUtils.getResponseHeaders((HttpServletResponse)responseWrapper);
            LogArgUtils.addHeaders(context.getArgs(), httpHeaders);
            log.info((Marker)Markers.appendEntries(context.getArgs()), "Outbound Message\n--------------------------------------\nSpan Kind: {}\nSpan ID: {}\nMethod: {}\nURL: {}\nStatus Code: {}\nHeaders: {}\n--------------------------------------", new Object[]{context.getSpanKind(), context.getSpanId(), context.getMethod(), context.getUrl(), responseWrapper.getStatus(), httpHeaders});
        }
    }

    public void logRequest(LogEventContext context, HttpServletRequest request) {
        if (context.getIncludeBody()) {
            String requestBody = RequestUtils.getRequestBody(request, 1024);
            HttpHeaders httpHeaders = RequestUtils.getRequestHeaders(request);
            LogArgUtils.addHeaders(context.getArgs(), httpHeaders);
            log.info((Marker)Markers.appendEntries(context.getArgs()), "Inbound Message\n--------------------------------------\nSpan Kind: {}\nSpan ID: {}\nMethod: {}\nURL: {}\nHeaders: {}\nPayload: {}\n--------------------------------------", new Object[]{context.getSpanKind(), context.getSpanId(), context.getMethod(), context.getUrl(), httpHeaders, requestBody});
        } else {
            HttpHeaders httpHeaders = RequestUtils.getRequestHeaders(request);
            LogArgUtils.addHeaders(context.getArgs(), httpHeaders);
            log.info((Marker)Markers.appendEntries(context.getArgs()), "Inbound Message\n--------------------------------------\nSpan Kind: {}\nSpan ID: {}\nMethod: {}\nURL: {}\nHeaders: {}\n--------------------------------------", new Object[]{context.getSpanKind(), context.getSpanId(), context.getMethod(), context.getUrl(), httpHeaders});
        }
    }
}

