/*
 * Decompiled with CFR 0.152.
 */
package com.goetschalckx.spring.logging.web.server;

import com.goetschalckx.spring.logging.web.server.RequestLoggingFilter;
import com.goetschalckx.spring.logging.web.server.ServerLogger;
import com.goetschalckx.spring.logging.web.span.SpanIdGenerator;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="logging.web.server", name={"enabled"}, havingValue="true")
public class ServerLoggingConfig {
    @Value(value="${logging.web.server.include-body:false}")
    private boolean includeBody = false;

    @Bean
    @ConditionalOnMissingBean
    public RequestLoggingFilter requestLoggingFilter(ServerLogger serverLogger, SpanIdGenerator spanIdGenerator) {
        return new RequestLoggingFilter(this.includeBody, serverLogger, spanIdGenerator);
    }

    @Bean
    @ConditionalOnMissingBean
    public ServerLogger serverLogger() {
        return new ServerLogger();
    }
}

