/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite.support.audio;

import android.media.AudioFormat;
import android.media.AudioRecord;
import androidx.annotation.RequiresApi;
import com.google.auto.value.AutoValue;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import org.tensorflow.lite.DataType;
import org.tensorflow.lite.support.audio.AutoValue_TensorAudio_TensorAudioFormat;
import org.tensorflow.lite.support.common.internal.SupportPreconditions;
import org.tensorflow.lite.support.tensorbuffer.TensorBuffer;

public class TensorAudio {
    private static final String TAG = TensorAudio.class.getSimpleName();
    private final FloatRingBuffer buffer;
    private final TensorAudioFormat format;

    public static TensorAudio create(TensorAudioFormat format, int sampleCounts) {
        return new TensorAudio(format, sampleCounts);
    }

    public static TensorAudio create(AudioFormat format, int sampleCounts) {
        return new TensorAudio(TensorAudioFormat.create(format), sampleCounts);
    }

    public void load(float[] src) {
        this.load(src, 0, src.length);
    }

    public void load(float[] src, int offsetInFloat, int sizeInFloat) {
        SupportPreconditions.checkArgument(sizeInFloat % this.format.getChannels() == 0, String.format("Size (%d) needs to be a multiplier of the number of channels (%d)", sizeInFloat, this.format.getChannels()));
        this.buffer.load(src, offsetInFloat, sizeInFloat);
    }

    public void load(short[] src) {
        this.load(src, 0, src.length);
    }

    public void load(short[] src, int offsetInShort, int sizeInShort) {
        SupportPreconditions.checkArgument(offsetInShort + sizeInShort <= src.length, String.format("Index out of range. offset (%d) + size (%d) should <= newData.length (%d)", offsetInShort, sizeInShort, src.length));
        float[] floatData = new float[sizeInShort];
        for (int i = 0; i < sizeInShort; ++i) {
            floatData[i] = (float)src[i + offsetInShort] * 1.0f / 32767.0f;
        }
        this.load(floatData);
    }

    @RequiresApi(value=23)
    public int load(AudioRecord record) {
        SupportPreconditions.checkArgument(this.format.equals(TensorAudioFormat.create(record.getFormat())), "Incompatible audio format.");
        int loadedValues = 0;
        if (record.getAudioFormat() == 4) {
            float[] newData = new float[record.getChannelCount() * record.getBufferSizeInFrames()];
            loadedValues = record.read(newData, 0, newData.length, 1);
            if (loadedValues > 0) {
                this.load(newData, 0, loadedValues);
                return loadedValues;
            }
        } else if (record.getAudioFormat() == 2) {
            short[] newData = new short[record.getChannelCount() * record.getBufferSizeInFrames()];
            loadedValues = record.read(newData, 0, newData.length, 1);
            if (loadedValues > 0) {
                this.load(newData, 0, loadedValues);
                return loadedValues;
            }
        } else {
            throw new IllegalArgumentException("Unsupported encoding. Requires ENCODING_PCM_16BIT or ENCODING_PCM_FLOAT.");
        }
        switch (loadedValues) {
            case -3: {
                throw new IllegalStateException("AudioRecord.ERROR_INVALID_OPERATION");
            }
            case -2: {
                throw new IllegalStateException("AudioRecord.ERROR_BAD_VALUE");
            }
            case -6: {
                throw new IllegalStateException("AudioRecord.ERROR_DEAD_OBJECT");
            }
            case -1: {
                throw new IllegalStateException("AudioRecord.ERROR");
            }
        }
        return 0;
    }

    public TensorBuffer getTensorBuffer() {
        ByteBuffer byteBuffer = this.buffer.getBuffer();
        TensorBuffer tensorBuffer = TensorBuffer.createFixedSize(new int[]{1, byteBuffer.asFloatBuffer().limit()}, DataType.FLOAT32);
        tensorBuffer.loadBuffer(byteBuffer);
        return tensorBuffer;
    }

    public TensorAudioFormat getFormat() {
        return this.format;
    }

    private TensorAudio(TensorAudioFormat format, int sampleCounts) {
        this.format = format;
        this.buffer = new FloatRingBuffer(sampleCounts * format.getChannels());
    }

    private static class FloatRingBuffer {
        private final float[] buffer;
        private int nextIndex = 0;

        public FloatRingBuffer(int flatSize) {
            this.buffer = new float[flatSize];
        }

        public void load(float[] newData) {
            this.load(newData, 0, newData.length);
        }

        public void load(float[] newData, int offset, int size) {
            SupportPreconditions.checkArgument(offset + size <= newData.length, String.format("Index out of range. offset (%d) + size (%d) should <= newData.length (%d)", offset, size, newData.length));
            if (size > this.buffer.length) {
                offset += size - this.buffer.length;
                size = this.buffer.length;
            }
            if (this.nextIndex + size < this.buffer.length) {
                System.arraycopy(newData, offset, this.buffer, this.nextIndex, size);
            } else {
                int firstChunkSize = this.buffer.length - this.nextIndex;
                System.arraycopy(newData, offset, this.buffer, this.nextIndex, firstChunkSize);
                System.arraycopy(newData, offset + firstChunkSize, this.buffer, 0, size - firstChunkSize);
            }
            this.nextIndex = (this.nextIndex + size) % this.buffer.length;
        }

        public ByteBuffer getBuffer() {
            ByteBuffer byteBuffer = ByteBuffer.allocate(DataType.FLOAT32.byteSize() * this.buffer.length);
            byteBuffer.order(ByteOrder.nativeOrder());
            FloatBuffer result = byteBuffer.asFloatBuffer();
            result.put(this.buffer, this.nextIndex, this.buffer.length - this.nextIndex);
            result.put(this.buffer, 0, this.nextIndex);
            byteBuffer.rewind();
            return byteBuffer;
        }

        public int getCapacity() {
            return this.buffer.length;
        }
    }

    @AutoValue
    public static abstract class TensorAudioFormat {
        private static final int DEFAULT_CHANNELS = 1;

        @RequiresApi(value=23)
        public static TensorAudioFormat create(AudioFormat format) {
            return TensorAudioFormat.builder().setChannels(format.getChannelCount()).setSampleRate(format.getSampleRate()).build();
        }

        public abstract int getChannels();

        public abstract int getSampleRate();

        public static Builder builder() {
            return new AutoValue_TensorAudio_TensorAudioFormat.Builder().setChannels(1);
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder setChannels(int var1);

            public abstract Builder setSampleRate(int var1);

            abstract TensorAudioFormat autoBuild();

            public TensorAudioFormat build() {
                TensorAudioFormat format = this.autoBuild();
                SupportPreconditions.checkArgument(format.getChannels() > 0, "Number of channels should be greater than 0");
                SupportPreconditions.checkArgument(format.getSampleRate() > 0, "Sample rate should be greater than 0");
                return format;
            }
        }
    }
}

