/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite.support.common;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.tensorflow.lite.support.common.internal.SupportPreconditions;

public class FileUtil {
    private FileUtil() {
    }

    public static @NonNull List<String> loadLabels(@NonNull Context context, @NonNull String filePath) throws IOException {
        return FileUtil.loadLabels(context, filePath, Charset.defaultCharset());
    }

    public static @NonNull List<String> loadLabels(@NonNull Context context, @NonNull String filePath, Charset cs) throws IOException {
        SupportPreconditions.checkNotNull(context, "Context cannot be null.");
        SupportPreconditions.checkNotNull(filePath, "File path cannot be null.");
        try (InputStream inputStream = context.getAssets().open(filePath);){
            List<String> list = FileUtil.loadLabels(inputStream, cs);
            return list;
        }
    }

    public static @NonNull List<String> loadLabels(@NonNull InputStream inputStream) throws IOException {
        return FileUtil.loadLabels(inputStream, Charset.defaultCharset());
    }

    public static @NonNull List<String> loadLabels(@NonNull InputStream inputStream, Charset cs) throws IOException {
        ArrayList<String> labels = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, cs));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.trim().length() <= 0) continue;
                labels.add(line);
            }
            ArrayList<String> arrayList = labels;
            return arrayList;
        }
    }

    public static @NonNull List<String> loadSingleColumnTextFile(@NonNull Context context, @NonNull String filePath, Charset cs) throws IOException {
        return FileUtil.loadLabels(context, filePath, cs);
    }

    public static @NonNull List<String> loadSingleColumnTextFile(@NonNull InputStream inputStream, Charset cs) throws IOException {
        return FileUtil.loadLabels(inputStream, cs);
    }

    public static @NonNull MappedByteBuffer loadMappedFile(@NonNull Context context, @NonNull String filePath) throws IOException {
        SupportPreconditions.checkNotNull(context, "Context should not be null.");
        SupportPreconditions.checkNotNull(filePath, "File path cannot be null.");
        try (AssetFileDescriptor fileDescriptor = context.getAssets().openFd(filePath);){
            MappedByteBuffer mappedByteBuffer;
            try (FileInputStream inputStream = new FileInputStream(fileDescriptor.getFileDescriptor());){
                FileChannel fileChannel = inputStream.getChannel();
                long startOffset = fileDescriptor.getStartOffset();
                long declaredLength = fileDescriptor.getDeclaredLength();
                mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, startOffset, declaredLength);
            }
            return mappedByteBuffer;
        }
    }

    public static @NonNull byte[] loadByteFromFile(@NonNull Context context, @NonNull String filePath) throws IOException {
        MappedByteBuffer buffer = FileUtil.loadMappedFile(context, filePath);
        byte[] byteArray = new byte[buffer.remaining()];
        buffer.get(byteArray);
        return byteArray;
    }
}

