/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite.support.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.tensorflow.lite.support.common.Operator;
import org.tensorflow.lite.support.common.Processor;
import org.tensorflow.lite.support.common.internal.SupportPreconditions;

public class SequentialProcessor<T>
implements Processor<T> {
    protected final List<Operator<T>> operatorList;
    protected final Map<String, List<Integer>> operatorIndex;

    protected SequentialProcessor(Builder<T> builder) {
        this.operatorList = ((Builder)builder).operatorList;
        this.operatorIndex = Collections.unmodifiableMap(((Builder)builder).operatorIndex);
    }

    @Override
    public T process(T x) {
        for (Operator<T> op : this.operatorList) {
            x = op.apply(x);
        }
        return x;
    }

    protected static class Builder<T> {
        private final List<Operator<T>> operatorList = new ArrayList<Operator<T>>();
        private final Map<String, List<Integer>> operatorIndex = new HashMap<String, List<Integer>>();

        protected Builder() {
        }

        public Builder<T> add(@NonNull Operator<T> op) {
            SupportPreconditions.checkNotNull(op, "Adding null Op is illegal.");
            this.operatorList.add(op);
            String operatorName = op.getClass().getName();
            if (!this.operatorIndex.containsKey(operatorName)) {
                this.operatorIndex.put(operatorName, new ArrayList());
            }
            this.operatorIndex.get(operatorName).add(this.operatorList.size() - 1);
            return this;
        }

        public SequentialProcessor<T> build() {
            return new SequentialProcessor(this);
        }
    }
}

