/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite.support.common.ops;

import org.tensorflow.lite.DataType;
import org.tensorflow.lite.support.common.TensorOperator;
import org.tensorflow.lite.support.common.internal.SupportPreconditions;
import org.tensorflow.lite.support.tensorbuffer.TensorBuffer;

public class CastOp
implements TensorOperator {
    private final DataType destinationType;

    public CastOp(DataType destinationType) {
        SupportPreconditions.checkArgument(destinationType == DataType.UINT8 || destinationType == DataType.FLOAT32, "Destination type " + destinationType + " is not supported.");
        this.destinationType = destinationType;
    }

    @Override
    public TensorBuffer apply(TensorBuffer input) {
        if (input.getDataType() == this.destinationType) {
            return input;
        }
        return TensorBuffer.createFrom(input, this.destinationType);
    }
}

