/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite.support.image;

import org.tensorflow.lite.support.image.ColorSpaceType;
import org.tensorflow.lite.support.image.ImageProperties;

final class AutoValue_ImageProperties
extends ImageProperties {
    private final int height;
    private final int width;
    private final ColorSpaceType colorSpaceType;

    private AutoValue_ImageProperties(int height, int width, ColorSpaceType colorSpaceType) {
        this.height = height;
        this.width = width;
        this.colorSpaceType = colorSpaceType;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public ColorSpaceType getColorSpaceType() {
        return this.colorSpaceType;
    }

    public String toString() {
        return "ImageProperties{height=" + this.height + ", width=" + this.width + ", colorSpaceType=" + (Object)((Object)this.colorSpaceType) + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ImageProperties) {
            ImageProperties that = (ImageProperties)o;
            return this.height == that.getHeight() && this.width == that.getWidth() && this.colorSpaceType.equals((Object)that.getColorSpaceType());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.height;
        h$ *= 1000003;
        h$ ^= this.width;
        h$ *= 1000003;
        return h$ ^= this.colorSpaceType.hashCode();
    }

    static final class Builder
    extends ImageProperties.Builder {
        private Integer height;
        private Integer width;
        private ColorSpaceType colorSpaceType;

        Builder() {
        }

        @Override
        public ImageProperties.Builder setHeight(int height) {
            this.height = height;
            return this;
        }

        @Override
        public ImageProperties.Builder setWidth(int width) {
            this.width = width;
            return this;
        }

        @Override
        public ImageProperties.Builder setColorSpaceType(ColorSpaceType colorSpaceType) {
            if (colorSpaceType == null) {
                throw new NullPointerException("Null colorSpaceType");
            }
            this.colorSpaceType = colorSpaceType;
            return this;
        }

        @Override
        ImageProperties autoBuild() {
            String missing = "";
            if (this.height == null) {
                missing = missing + " height";
            }
            if (this.width == null) {
                missing = missing + " width";
            }
            if (this.colorSpaceType == null) {
                missing = missing + " colorSpaceType";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_ImageProperties(this.height, this.width, this.colorSpaceType);
        }
    }
}

