/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite.support.image;

import android.graphics.Bitmap;
import android.media.Image;
import org.tensorflow.lite.DataType;
import org.tensorflow.lite.support.common.internal.SupportPreconditions;
import org.tensorflow.lite.support.image.ColorSpaceType;
import org.tensorflow.lite.support.image.ImageContainer;
import org.tensorflow.lite.support.image.ImageConversions;
import org.tensorflow.lite.support.tensorbuffer.TensorBuffer;

final class BitmapContainer
implements ImageContainer {
    private final Bitmap bitmap;

    static BitmapContainer create(Bitmap bitmap) {
        return new BitmapContainer(bitmap);
    }

    private BitmapContainer(Bitmap bitmap) {
        SupportPreconditions.checkNotNull(bitmap, "Cannot load null bitmap.");
        SupportPreconditions.checkArgument(bitmap.getConfig().equals((Object)Bitmap.Config.ARGB_8888), "Only supports loading ARGB_8888 bitmaps.");
        this.bitmap = bitmap;
    }

    @Override
    public BitmapContainer clone() {
        return BitmapContainer.create(this.bitmap.copy(this.bitmap.getConfig(), this.bitmap.isMutable()));
    }

    @Override
    public Bitmap getBitmap() {
        return this.bitmap;
    }

    @Override
    public TensorBuffer getTensorBuffer(DataType dataType) {
        TensorBuffer buffer = TensorBuffer.createDynamic(dataType);
        ImageConversions.convertBitmapToTensorBuffer(this.bitmap, buffer);
        return buffer;
    }

    @Override
    public Image getMediaImage() {
        throw new UnsupportedOperationException("Converting from Bitmap to android.media.Image is unsupported.");
    }

    @Override
    public int getWidth() {
        return this.bitmap.getWidth();
    }

    @Override
    public int getHeight() {
        return this.bitmap.getHeight();
    }

    @Override
    public ColorSpaceType getColorSpaceType() {
        return ColorSpaceType.fromBitmapConfig(this.bitmap.getConfig());
    }
}

