/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite.support.image;

import android.graphics.RectF;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.tensorflow.lite.DataType;
import org.tensorflow.lite.support.common.internal.SupportPreconditions;
import org.tensorflow.lite.support.tensorbuffer.TensorBuffer;

public final class BoundingBoxUtil {
    public static List<RectF> convert(TensorBuffer tensor, int[] valueIndex, int boundingBoxAxis, Type type, CoordinateType coordinateType, int height, int width) {
        int[] shape = tensor.getShape();
        SupportPreconditions.checkArgument(boundingBoxAxis >= -shape.length && boundingBoxAxis < shape.length, String.format("Axis %d is not in range (-(D+1), D), where D is the number of dimensions of input tensor (shape=%s)", boundingBoxAxis, Arrays.toString(shape)));
        if (boundingBoxAxis < 0) {
            boundingBoxAxis = shape.length + boundingBoxAxis;
        }
        SupportPreconditions.checkArgument(shape[boundingBoxAxis] == 4, String.format("Size of bounding box dimension %d is not 4. Got %d in shape %s", boundingBoxAxis, shape[boundingBoxAxis], Arrays.toString(shape)));
        SupportPreconditions.checkArgument(valueIndex.length == 4, String.format("Bounding box index array length %d is not 4. Got index array %s", valueIndex.length, Arrays.toString(valueIndex)));
        SupportPreconditions.checkArgument(tensor.getDataType() == DataType.FLOAT32, "Bounding Boxes only create from FLOAT32 buffers. Got: " + tensor.getDataType().name());
        ArrayList<RectF> boundingBoxList = new ArrayList<RectF>();
        int a = 1;
        for (int i = 0; i < boundingBoxAxis; ++i) {
            a *= shape[i];
        }
        int b = 1;
        for (int i = boundingBoxAxis + 1; i < shape.length; ++i) {
            b *= shape[i];
        }
        float[] values = new float[4];
        ByteBuffer byteBuffer = tensor.getBuffer();
        byteBuffer.rewind();
        FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
        for (int i = 0; i < a; ++i) {
            for (int j = 0; j < b; ++j) {
                for (int k = 0; k < 4; ++k) {
                    values[k] = floatBuffer.get((i * 4 + k) * b + j);
                }
                boundingBoxList.add(BoundingBoxUtil.convertOneBoundingBox(values, valueIndex, type, coordinateType, height, width));
            }
        }
        byteBuffer.rewind();
        return boundingBoxList;
    }

    private static RectF convertOneBoundingBox(float[] values, int[] valueIndex, Type type, CoordinateType coordinateType, int height, int width) {
        float[] orderedValues = new float[4];
        for (int i = 0; i < 4; ++i) {
            orderedValues[i] = values[valueIndex[i]];
        }
        return BoundingBoxUtil.convertOneBoundingBox(orderedValues, type, coordinateType, height, width);
    }

    private static RectF convertOneBoundingBox(float[] values, Type type, CoordinateType coordinateType, int height, int width) {
        switch (type) {
            case BOUNDARIES: {
                return BoundingBoxUtil.convertFromBoundaries(values, coordinateType, height, width);
            }
            case UPPER_LEFT: {
                return BoundingBoxUtil.convertFromUpperLeft(values, coordinateType, height, width);
            }
            case CENTER: {
                return BoundingBoxUtil.convertFromCenter(values, coordinateType, height, width);
            }
        }
        throw new IllegalArgumentException("Cannot recognize BoundingBox.Type " + (Object)((Object)type));
    }

    private static RectF convertFromBoundaries(float[] values, CoordinateType coordinateType, int imageHeight, int imageWidth) {
        float left = values[0];
        float top = values[1];
        float right = values[2];
        float bottom = values[3];
        return BoundingBoxUtil.getRectF(left, top, right, bottom, imageHeight, imageWidth, coordinateType);
    }

    private static RectF convertFromUpperLeft(float[] values, CoordinateType coordinateType, int imageHeight, int imageWidth) {
        float left = values[0];
        float top = values[1];
        float right = values[0] + values[2];
        float bottom = values[1] + values[3];
        return BoundingBoxUtil.getRectF(left, top, right, bottom, imageHeight, imageWidth, coordinateType);
    }

    private static RectF convertFromCenter(float[] values, CoordinateType coordinateType, int imageHeight, int imageWidth) {
        float centerX = values[0];
        float centerY = values[1];
        float w = values[2];
        float h = values[3];
        float left = centerX - w / 2.0f;
        float top = centerY - h / 2.0f;
        float right = centerX + w / 2.0f;
        float bottom = centerY + h / 2.0f;
        return BoundingBoxUtil.getRectF(left, top, right, bottom, imageHeight, imageWidth, coordinateType);
    }

    private static RectF getRectF(float left, float top, float right, float bottom, int imageHeight, int imageWidth, CoordinateType coordinateType) {
        if (coordinateType == CoordinateType.PIXEL) {
            return new RectF(left, top, right, bottom);
        }
        if (coordinateType == CoordinateType.RATIO) {
            return new RectF(left * (float)imageWidth, top * (float)imageHeight, right * (float)imageWidth, bottom * (float)imageHeight);
        }
        throw new IllegalArgumentException("Cannot convert coordinate type " + (Object)((Object)coordinateType));
    }

    private BoundingBoxUtil() {
    }

    public static enum CoordinateType {
        RATIO,
        PIXEL;

    }

    public static enum Type {
        BOUNDARIES,
        UPPER_LEFT,
        CENTER;

    }
}

