/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite.support.image;

import android.graphics.Bitmap;
import java.util.Arrays;
import org.tensorflow.lite.support.common.internal.SupportPreconditions;
import org.tensorflow.lite.support.image.ImageConversions;
import org.tensorflow.lite.support.tensorbuffer.TensorBuffer;

public enum ColorSpaceType {
    RGB(0){
        private static final int CHANNEL_VALUE = 3;

        @Override
        Bitmap convertTensorBufferToBitmap(TensorBuffer buffer) {
            return ImageConversions.convertRgbTensorBufferToBitmap(buffer);
        }

        @Override
        int getChannelValue() {
            return 3;
        }

        @Override
        int[] getNormalizedShape(int[] shape) {
            switch (shape.length) {
                case 3: {
                    return ColorSpaceType.insertValue(shape, 0, 1);
                }
                case 4: {
                    return shape;
                }
            }
            throw new IllegalArgumentException(this.getShapeInfoMessage() + "The provided image shape is " + Arrays.toString(shape));
        }

        @Override
        int getNumElements(int height, int width) {
            return height * width * 3;
        }

        @Override
        String getShapeInfoMessage() {
            return "The shape of a RGB image should be (h, w, c) or (1, h, w, c), and channels representing R, G, B in order. ";
        }

        @Override
        Bitmap.Config toBitmapConfig() {
            return Bitmap.Config.ARGB_8888;
        }
    }
    ,
    GRAYSCALE(1){
        private static final int CHANNEL_VALUE = 1;

        @Override
        Bitmap convertTensorBufferToBitmap(TensorBuffer buffer) {
            return ImageConversions.convertGrayscaleTensorBufferToBitmap(buffer);
        }

        @Override
        int getChannelValue() {
            return 1;
        }

        @Override
        int[] getNormalizedShape(int[] shape) {
            switch (shape.length) {
                case 2: {
                    int[] shapeWithBatch = ColorSpaceType.insertValue(shape, 0, 1);
                    return ColorSpaceType.insertValue(shapeWithBatch, 3, 1);
                }
                case 4: {
                    return shape;
                }
            }
            throw new IllegalArgumentException(this.getShapeInfoMessage() + "The provided image shape is " + Arrays.toString(shape));
        }

        @Override
        int getNumElements(int height, int width) {
            return height * width;
        }

        @Override
        String getShapeInfoMessage() {
            return "The shape of a grayscale image should be (h, w) or (1, h, w, 1). ";
        }

        @Override
        Bitmap.Config toBitmapConfig() {
            return Bitmap.Config.ALPHA_8;
        }
    }
    ,
    NV12(2){

        @Override
        int getNumElements(int height, int width) {
            return ColorSpaceType.getYuv420NumElements(height, width);
        }
    }
    ,
    NV21(3){

        @Override
        int getNumElements(int height, int width) {
            return ColorSpaceType.getYuv420NumElements(height, width);
        }
    }
    ,
    YV12(4){

        @Override
        int getNumElements(int height, int width) {
            return ColorSpaceType.getYuv420NumElements(height, width);
        }
    }
    ,
    YV21(5){

        @Override
        int getNumElements(int height, int width) {
            return ColorSpaceType.getYuv420NumElements(height, width);
        }
    }
    ,
    YUV_420_888(6){

        @Override
        int getNumElements(int height, int width) {
            return ColorSpaceType.getYuv420NumElements(height, width);
        }
    };

    private static final int BATCH_DIM = 0;
    private static final int BATCH_VALUE = 1;
    private static final int HEIGHT_DIM = 1;
    private static final int WIDTH_DIM = 2;
    private static final int CHANNEL_DIM = 3;
    private final int value;

    private ColorSpaceType(int value) {
        this.value = value;
    }

    static ColorSpaceType fromBitmapConfig(Bitmap.Config config) {
        switch (config) {
            case ARGB_8888: {
                return RGB;
            }
            case ALPHA_8: {
                return GRAYSCALE;
            }
        }
        throw new IllegalArgumentException("Bitmap configuration: " + config + ", is not supported yet.");
    }

    static ColorSpaceType fromImageFormat(int imageFormat) {
        switch (imageFormat) {
            case 17: {
                return NV21;
            }
            case 842094169: {
                return YV12;
            }
            case 35: {
                return YUV_420_888;
            }
        }
        throw new IllegalArgumentException("ImageFormat: " + imageFormat + ", is not supported yet.");
    }

    public int getValue() {
        return this.value;
    }

    void assertShape(int[] shape) {
        this.assertRgbOrGrayScale("assertShape()");
        int[] normalizedShape = this.getNormalizedShape(shape);
        SupportPreconditions.checkArgument(this.isValidNormalizedShape(normalizedShape), this.getShapeInfoMessage() + "The provided image shape is " + Arrays.toString(shape));
    }

    void assertNumElements(int numElements, int height, int width) {
        SupportPreconditions.checkArgument(numElements >= this.getNumElements(height, width), String.format("The given number of elements (%d) does not match the image (%s) in %d x %d. The expected number of elements should be at least %d.", numElements, this.name(), height, width, this.getNumElements(height, width)));
    }

    Bitmap convertTensorBufferToBitmap(TensorBuffer buffer) {
        throw new UnsupportedOperationException("convertTensorBufferToBitmap() is unsupported for the color space type " + this.name());
    }

    int getWidth(int[] shape) {
        this.assertRgbOrGrayScale("getWidth()");
        this.assertShape(shape);
        return this.getNormalizedShape(shape)[2];
    }

    int getHeight(int[] shape) {
        this.assertRgbOrGrayScale("getHeight()");
        this.assertShape(shape);
        return this.getNormalizedShape(shape)[1];
    }

    int getChannelValue() {
        throw new UnsupportedOperationException("getChannelValue() is unsupported for the color space type " + this.name());
    }

    int[] getNormalizedShape(int[] shape) {
        throw new UnsupportedOperationException("getNormalizedShape() is unsupported for the color space type " + this.name());
    }

    String getShapeInfoMessage() {
        throw new UnsupportedOperationException("getShapeInfoMessage() is unsupported for the color space type " + this.name());
    }

    Bitmap.Config toBitmapConfig() {
        throw new UnsupportedOperationException("toBitmapConfig() is unsupported for the color space type " + this.name());
    }

    abstract int getNumElements(int var1, int var2);

    private static int getYuv420NumElements(int height, int width) {
        return height * width + (height + 1) / 2 * ((width + 1) / 2) * 2;
    }

    private static int[] insertValue(int[] array, int pos, int value) {
        int i;
        int[] newArray = new int[array.length + 1];
        for (i = 0; i < pos; ++i) {
            newArray[i] = array[i];
        }
        newArray[pos] = value;
        for (i = pos + 1; i < newArray.length; ++i) {
            newArray[i] = array[i - 1];
        }
        return newArray;
    }

    protected boolean isValidNormalizedShape(int[] shape) {
        return shape[0] == 1 && shape[1] > 0 && shape[2] > 0 && shape[3] == this.getChannelValue();
    }

    private void assertRgbOrGrayScale(String unsupportedMethodName) {
        if (this != RGB && this != GRAYSCALE) {
            throw new UnsupportedOperationException(unsupportedMethodName + " only supports RGB and GRAYSCALE formats, but not " + this.name());
        }
    }
}

