/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite.support.image;

import android.graphics.Bitmap;
import android.graphics.Color;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.tensorflow.lite.DataType;
import org.tensorflow.lite.support.image.ColorSpaceType;
import org.tensorflow.lite.support.tensorbuffer.TensorBuffer;

class ImageConversions {
    static Bitmap convertRgbTensorBufferToBitmap(TensorBuffer buffer) {
        int[] shape = buffer.getShape();
        ColorSpaceType rgb = ColorSpaceType.RGB;
        rgb.assertShape(shape);
        int h = rgb.getHeight(shape);
        int w = rgb.getWidth(shape);
        Bitmap bitmap = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)rgb.toBitmapConfig());
        int[] intValues = new int[w * h];
        int[] rgbValues = buffer.getIntArray();
        int j = 0;
        for (int i = 0; i < intValues.length; ++i) {
            int r = rgbValues[j++];
            int g = rgbValues[j++];
            int b = rgbValues[j++];
            intValues[i] = Color.rgb((int)r, (int)g, (int)b);
        }
        bitmap.setPixels(intValues, 0, w, 0, 0, w, h);
        return bitmap;
    }

    static Bitmap convertGrayscaleTensorBufferToBitmap(TensorBuffer buffer) {
        TensorBuffer uint8Buffer = buffer.getDataType() == DataType.UINT8 ? buffer : TensorBuffer.createFrom(buffer, DataType.UINT8);
        int[] shape = uint8Buffer.getShape();
        ColorSpaceType grayscale = ColorSpaceType.GRAYSCALE;
        grayscale.assertShape(shape);
        Bitmap bitmap = Bitmap.createBitmap((int)grayscale.getWidth(shape), (int)grayscale.getHeight(shape), (Bitmap.Config)grayscale.toBitmapConfig());
        uint8Buffer.getBuffer().rewind();
        bitmap.copyPixelsFromBuffer((Buffer)uint8Buffer.getBuffer());
        return bitmap;
    }

    static void convertBitmapToTensorBuffer(Bitmap bitmap, TensorBuffer buffer) {
        int w = bitmap.getWidth();
        int h = bitmap.getHeight();
        int[] intValues = new int[w * h];
        bitmap.getPixels(intValues, 0, w, 0, 0, w, h);
        int[] shape = new int[]{h, w, 3};
        switch (buffer.getDataType()) {
            case UINT8: {
                byte[] byteArr = new byte[w * h * 3];
                int j = 0;
                for (int i = 0; i < intValues.length; ++i) {
                    byteArr[j++] = (byte)(intValues[i] >> 16 & 0xFF);
                    byteArr[j++] = (byte)(intValues[i] >> 8 & 0xFF);
                    byteArr[j++] = (byte)(intValues[i] & 0xFF);
                }
                ByteBuffer byteBuffer = ByteBuffer.wrap(byteArr);
                byteBuffer.order(ByteOrder.nativeOrder());
                buffer.loadBuffer(byteBuffer, shape);
                break;
            }
            case FLOAT32: {
                float[] floatArr = new float[w * h * 3];
                int j = 0;
                for (int i = 0; i < intValues.length; ++i) {
                    floatArr[j++] = intValues[i] >> 16 & 0xFF;
                    floatArr[j++] = intValues[i] >> 8 & 0xFF;
                    floatArr[j++] = intValues[i] & 0xFF;
                }
                buffer.loadArray(floatArr, shape);
                break;
            }
            default: {
                throw new IllegalStateException("The type of TensorBuffer, " + buffer.getBuffer() + ", is unsupported.");
            }
        }
    }

    private ImageConversions() {
    }
}

