/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite.support.image;

import android.graphics.PointF;
import android.graphics.RectF;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.tensorflow.lite.support.common.Operator;
import org.tensorflow.lite.support.common.SequentialProcessor;
import org.tensorflow.lite.support.common.TensorOperator;
import org.tensorflow.lite.support.common.internal.SupportPreconditions;
import org.tensorflow.lite.support.image.ImageOperator;
import org.tensorflow.lite.support.image.TensorImage;
import org.tensorflow.lite.support.image.ops.Rot90Op;
import org.tensorflow.lite.support.image.ops.TensorOperatorWrapper;

public class ImageProcessor
extends SequentialProcessor<TensorImage> {
    private ImageProcessor(Builder builder) {
        super(builder);
    }

    public PointF inverseTransform(PointF point, int inputImageHeight, int inputImageWidth) {
        ArrayList<Integer> widths = new ArrayList<Integer>();
        ArrayList<Integer> heights = new ArrayList<Integer>();
        int currentWidth = inputImageWidth;
        int currentHeight = inputImageHeight;
        for (Operator op : this.operatorList) {
            widths.add(currentWidth);
            heights.add(currentHeight);
            ImageOperator imageOperator = (ImageOperator)op;
            int newHeight = imageOperator.getOutputImageHeight(currentHeight, currentWidth);
            int newWidth = imageOperator.getOutputImageWidth(currentHeight, currentWidth);
            currentHeight = newHeight;
            currentWidth = newWidth;
        }
        ListIterator opIterator = this.operatorList.listIterator(this.operatorList.size());
        ListIterator widthIterator = widths.listIterator(widths.size());
        ListIterator heightIterator = heights.listIterator(heights.size());
        while (opIterator.hasPrevious()) {
            ImageOperator imageOperator = (ImageOperator)opIterator.previous();
            int height = (Integer)heightIterator.previous();
            int width = (Integer)widthIterator.previous();
            point = imageOperator.inverseTransform(point, height, width);
        }
        return point;
    }

    public RectF inverseTransform(RectF rect, int inputImageHeight, int inputImageWidth) {
        PointF p1 = this.inverseTransform(new PointF(rect.left, rect.top), inputImageHeight, inputImageWidth);
        PointF p2 = this.inverseTransform(new PointF(rect.right, rect.bottom), inputImageHeight, inputImageWidth);
        return new RectF(Math.min(p1.x, p2.x), Math.min(p1.y, p2.y), Math.max(p1.x, p2.x), Math.max(p1.y, p2.y));
    }

    @Override
    public TensorImage process(TensorImage image) {
        return super.process(image);
    }

    public void updateNumberOfRotations(int k) {
        this.updateNumberOfRotations(k, 0);
    }

    public synchronized void updateNumberOfRotations(int k, int occurrence) {
        SupportPreconditions.checkState(this.operatorIndex.containsKey(Rot90Op.class.getName()), "The Rot90Op has not been added to the ImageProcessor.");
        List indexes = (List)this.operatorIndex.get(Rot90Op.class.getName());
        SupportPreconditions.checkElementIndex(occurrence, indexes.size(), "occurrence");
        int index = (Integer)indexes.get(occurrence);
        Rot90Op newRot = new Rot90Op(k);
        this.operatorList.set(index, newRot);
    }

    public static class Builder
    extends SequentialProcessor.Builder<TensorImage> {
        public Builder add(ImageOperator op) {
            super.add(op);
            return this;
        }

        public Builder add(TensorOperator op) {
            return this.add(new TensorOperatorWrapper(op));
        }

        public ImageProcessor build() {
            return new ImageProcessor(this);
        }
    }
}

