/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite.support.image;

import com.google.auto.value.AutoValue;
import org.tensorflow.lite.support.common.internal.SupportPreconditions;
import org.tensorflow.lite.support.image.AutoValue_ImageProperties;
import org.tensorflow.lite.support.image.ColorSpaceType;

@AutoValue
public abstract class ImageProperties {
    private static final int DEFAULT_HEIGHT = -1;
    private static final int DEFAULT_WIDTH = -1;

    public abstract int getHeight();

    public abstract int getWidth();

    public abstract ColorSpaceType getColorSpaceType();

    public static Builder builder() {
        return new AutoValue_ImageProperties.Builder().setHeight(-1).setWidth(-1);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setHeight(int var1);

        public abstract Builder setWidth(int var1);

        public abstract Builder setColorSpaceType(ColorSpaceType var1);

        abstract ImageProperties autoBuild();

        public ImageProperties build() {
            ImageProperties properties = this.autoBuild();
            SupportPreconditions.checkState(properties.getHeight() >= 0, "Negative image height is not allowed.");
            SupportPreconditions.checkState(properties.getWidth() >= 0, "Negative image width is not allowed.");
            return properties;
        }
    }
}

