/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite.support.image;

import android.graphics.Bitmap;
import android.media.Image;
import org.tensorflow.lite.DataType;
import org.tensorflow.lite.support.common.internal.SupportPreconditions;
import org.tensorflow.lite.support.image.ColorSpaceType;
import org.tensorflow.lite.support.image.ImageContainer;
import org.tensorflow.lite.support.tensorbuffer.TensorBuffer;

final class MediaImageContainer
implements ImageContainer {
    private final Image image;

    static MediaImageContainer create(Image image) {
        return new MediaImageContainer(image);
    }

    private MediaImageContainer(Image image) {
        SupportPreconditions.checkNotNull(image, "Cannot load null Image.");
        SupportPreconditions.checkArgument(image.getFormat() == 35, "Only supports loading YUV_420_888 Image.");
        this.image = image;
    }

    @Override
    public MediaImageContainer clone() {
        throw new UnsupportedOperationException("android.media.Image is an abstract class and cannot be cloned.");
    }

    @Override
    public Bitmap getBitmap() {
        throw new UnsupportedOperationException("Converting an android.media.Image to Bitmap is not supported.");
    }

    @Override
    public TensorBuffer getTensorBuffer(DataType dataType) {
        throw new UnsupportedOperationException("Converting an android.media.Image to TesorBuffer is not supported.");
    }

    @Override
    public Image getMediaImage() {
        return this.image;
    }

    @Override
    public int getWidth() {
        return this.image.getWidth();
    }

    @Override
    public int getHeight() {
        return this.image.getHeight();
    }

    @Override
    public ColorSpaceType getColorSpaceType() {
        return ColorSpaceType.fromImageFormat(this.image.getFormat());
    }
}

