/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite.support.image;

import com.google.android.odml.image.BitmapExtractor;
import com.google.android.odml.image.ByteBufferExtractor;
import com.google.android.odml.image.MediaImageExtractor;
import com.google.android.odml.image.MlImage;
import com.google.auto.value.AutoValue;
import java.nio.ByteBuffer;
import org.tensorflow.lite.support.image.AutoValue_MlImageAdapter_ImageFormatProxy;
import org.tensorflow.lite.support.image.ColorSpaceType;
import org.tensorflow.lite.support.image.ImageProperties;
import org.tensorflow.lite.support.image.TensorImage;

public class MlImageAdapter {
    public static TensorImage createTensorImageFrom(MlImage mlImage) {
        com.google.android.odml.image.ImageProperties mlImageProperties = (com.google.android.odml.image.ImageProperties)mlImage.getContainedImageProperties().get(0);
        switch (mlImageProperties.getStorageType()) {
            case 1: {
                return TensorImage.fromBitmap(BitmapExtractor.extract((MlImage)mlImage));
            }
            case 3: {
                TensorImage mediaTensorImage = new TensorImage();
                mediaTensorImage.load(MediaImageExtractor.extract((MlImage)mlImage));
                return mediaTensorImage;
            }
            case 2: {
                ByteBuffer buffer = ByteBufferExtractor.extract((MlImage)mlImage);
                ImageFormatProxy formatProxy = ImageFormatProxy.createFromImageFormat(mlImageProperties.getImageFormat());
                TensorImage byteBufferTensorImage = new TensorImage();
                ImageProperties properties = ImageProperties.builder().setColorSpaceType(formatProxy.getColorSpaceType()).setHeight(mlImage.getHeight()).setWidth(mlImage.getWidth()).build();
                byteBufferTensorImage.load(buffer, properties);
                return byteBufferTensorImage;
            }
        }
        throw new IllegalArgumentException("Illegal storage type: " + mlImageProperties.getStorageType());
    }

    public static ColorSpaceType createColorSpaceTypeFrom(int imageFormat) {
        return ImageFormatProxy.createFromImageFormat(imageFormat).getColorSpaceType();
    }

    private MlImageAdapter() {
    }

    @AutoValue
    static abstract class ImageFormatProxy {
        ImageFormatProxy() {
        }

        abstract ColorSpaceType getColorSpaceType();

        abstract int getImageFormat();

        static ImageFormatProxy createFromImageFormat(int format) {
            switch (format) {
                case 2: {
                    return new AutoValue_MlImageAdapter_ImageFormatProxy(ColorSpaceType.RGB, format);
                }
                case 3: {
                    return new AutoValue_MlImageAdapter_ImageFormatProxy(ColorSpaceType.NV12, format);
                }
                case 4: {
                    return new AutoValue_MlImageAdapter_ImageFormatProxy(ColorSpaceType.NV21, format);
                }
                case 5: {
                    return new AutoValue_MlImageAdapter_ImageFormatProxy(ColorSpaceType.YV12, format);
                }
                case 6: {
                    return new AutoValue_MlImageAdapter_ImageFormatProxy(ColorSpaceType.YV21, format);
                }
                case 7: {
                    return new AutoValue_MlImageAdapter_ImageFormatProxy(ColorSpaceType.YUV_420_888, format);
                }
                case 8: {
                    return new AutoValue_MlImageAdapter_ImageFormatProxy(ColorSpaceType.GRAYSCALE, format);
                }
                case 0: 
                case 1: 
                case 9: {
                    throw new IllegalArgumentException("Cannot create ColorSpaceType from MlImage format: " + format);
                }
            }
            throw new AssertionError((Object)("Illegal @ImageFormat: " + format));
        }
    }
}

