/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite.support.image;

import android.graphics.Bitmap;
import android.media.Image;
import android.util.Log;
import org.tensorflow.lite.DataType;
import org.tensorflow.lite.support.common.internal.SupportPreconditions;
import org.tensorflow.lite.support.image.ColorSpaceType;
import org.tensorflow.lite.support.image.ImageContainer;
import org.tensorflow.lite.support.image.ImageProperties;
import org.tensorflow.lite.support.tensorbuffer.TensorBuffer;

final class TensorBufferContainer
implements ImageContainer {
    private final TensorBuffer buffer;
    private final ColorSpaceType colorSpaceType;
    private final int height;
    private final int width;
    private static final String TAG = TensorBufferContainer.class.getSimpleName();

    static TensorBufferContainer create(TensorBuffer buffer, ColorSpaceType colorSpaceType) {
        SupportPreconditions.checkArgument(colorSpaceType == ColorSpaceType.RGB || colorSpaceType == ColorSpaceType.GRAYSCALE, "Only ColorSpaceType.RGB and ColorSpaceType.GRAYSCALE are supported. Use `create(TensorBuffer, ImageProperties)` for other color space types.");
        return new TensorBufferContainer(buffer, colorSpaceType, colorSpaceType.getHeight(buffer.getShape()), colorSpaceType.getWidth(buffer.getShape()));
    }

    static TensorBufferContainer create(TensorBuffer buffer, ImageProperties imageProperties) {
        return new TensorBufferContainer(buffer, imageProperties.getColorSpaceType(), imageProperties.getHeight(), imageProperties.getWidth());
    }

    private TensorBufferContainer(TensorBuffer buffer, ColorSpaceType colorSpaceType, int height, int width) {
        SupportPreconditions.checkArgument(colorSpaceType != ColorSpaceType.YUV_420_888, "The actual encoding format of YUV420 is required. Choose a ColorSpaceType from: NV12, NV21, YV12, YV21. Use YUV_420_888 only when loading an android.media.Image.");
        colorSpaceType.assertNumElements(buffer.getFlatSize(), height, width);
        this.buffer = buffer;
        this.colorSpaceType = colorSpaceType;
        this.height = height;
        this.width = width;
    }

    @Override
    public TensorBufferContainer clone() {
        return new TensorBufferContainer(TensorBuffer.createFrom(this.buffer, this.buffer.getDataType()), this.colorSpaceType, this.getHeight(), this.getWidth());
    }

    @Override
    public Bitmap getBitmap() {
        if (this.buffer.getDataType() != DataType.UINT8) {
            Log.w((String)TAG, (String)"<Warning> TensorBufferContainer is holding a non-uint8 image. The conversion to Bitmap will cause numeric casting and clamping on the data value.");
        }
        return this.colorSpaceType.convertTensorBufferToBitmap(this.buffer);
    }

    @Override
    public TensorBuffer getTensorBuffer(DataType dataType) {
        return this.buffer.getDataType() == dataType ? this.buffer : TensorBuffer.createFrom(this.buffer, dataType);
    }

    @Override
    public Image getMediaImage() {
        throw new UnsupportedOperationException("Converting from TensorBuffer to android.media.Image is unsupported.");
    }

    @Override
    public int getWidth() {
        this.colorSpaceType.assertNumElements(this.buffer.getFlatSize(), this.height, this.width);
        return this.width;
    }

    @Override
    public int getHeight() {
        this.colorSpaceType.assertNumElements(this.buffer.getFlatSize(), this.height, this.width);
        return this.height;
    }

    @Override
    public ColorSpaceType getColorSpaceType() {
        return this.colorSpaceType;
    }
}

