/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite.support.image;

import android.graphics.Bitmap;
import android.media.Image;
import java.nio.ByteBuffer;
import org.tensorflow.lite.DataType;
import org.tensorflow.lite.support.common.internal.SupportPreconditions;
import org.tensorflow.lite.support.image.BitmapContainer;
import org.tensorflow.lite.support.image.ColorSpaceType;
import org.tensorflow.lite.support.image.ImageContainer;
import org.tensorflow.lite.support.image.ImageProperties;
import org.tensorflow.lite.support.image.MediaImageContainer;
import org.tensorflow.lite.support.image.TensorBufferContainer;
import org.tensorflow.lite.support.tensorbuffer.TensorBuffer;

public class TensorImage {
    private final DataType dataType;
    private ImageContainer container = null;

    public TensorImage() {
        this(DataType.UINT8);
    }

    public TensorImage(DataType dataType) {
        SupportPreconditions.checkArgument(dataType == DataType.UINT8 || dataType == DataType.FLOAT32, "Illegal data type for TensorImage: Only FLOAT32 and UINT8 are accepted");
        this.dataType = dataType;
    }

    public static TensorImage fromBitmap(Bitmap bitmap) {
        TensorImage image = new TensorImage();
        image.load(bitmap);
        return image;
    }

    public static TensorImage createFrom(TensorImage src, DataType dataType) {
        TensorImage dst = new TensorImage(dataType);
        dst.container = src.container.clone();
        return dst;
    }

    public void load(Bitmap bitmap) {
        this.container = BitmapContainer.create(bitmap);
    }

    public void load(float[] pixels, int[] shape) {
        TensorBuffer buffer = TensorBuffer.createDynamic(this.getDataType());
        buffer.loadArray(pixels, shape);
        this.load(buffer);
    }

    public void load(int[] pixels, int[] shape) {
        TensorBuffer buffer = TensorBuffer.createDynamic(this.getDataType());
        buffer.loadArray(pixels, shape);
        this.load(buffer);
    }

    public void load(TensorBuffer buffer) {
        this.load(buffer, ColorSpaceType.RGB);
    }

    public void load(TensorBuffer buffer, ColorSpaceType colorSpaceType) {
        SupportPreconditions.checkArgument(colorSpaceType == ColorSpaceType.RGB || colorSpaceType == ColorSpaceType.GRAYSCALE, "Only ColorSpaceType.RGB and ColorSpaceType.GRAYSCALE are supported. Use `load(TensorBuffer, ImageProperties)` for other color space types.");
        this.container = TensorBufferContainer.create(buffer, colorSpaceType);
    }

    public void load(TensorBuffer buffer, ImageProperties imageProperties) {
        this.container = TensorBufferContainer.create(buffer, imageProperties);
    }

    public void load(ByteBuffer buffer, ImageProperties imageProperties) {
        TensorBuffer tensorBuffer = TensorBuffer.createDynamic(DataType.UINT8);
        tensorBuffer.loadBuffer(buffer, new int[]{buffer.limit()});
        this.container = TensorBufferContainer.create(tensorBuffer, imageProperties);
    }

    public void load(Image image) {
        this.container = MediaImageContainer.create(image);
    }

    public Bitmap getBitmap() {
        if (this.container == null) {
            throw new IllegalStateException("No image has been loaded yet.");
        }
        return this.container.getBitmap();
    }

    public ByteBuffer getBuffer() {
        return this.getTensorBuffer().getBuffer();
    }

    public TensorBuffer getTensorBuffer() {
        if (this.container == null) {
            throw new IllegalStateException("No image has been loaded yet.");
        }
        return this.container.getTensorBuffer(this.dataType);
    }

    public Image getMediaImage() {
        if (this.container == null) {
            throw new IllegalStateException("No image has been loaded yet.");
        }
        return this.container.getMediaImage();
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public ColorSpaceType getColorSpaceType() {
        if (this.container == null) {
            throw new IllegalStateException("No image has been loaded yet.");
        }
        return this.container.getColorSpaceType();
    }

    public int getWidth() {
        if (this.container == null) {
            throw new IllegalStateException("No image has been loaded yet.");
        }
        return this.container.getWidth();
    }

    public int getHeight() {
        if (this.container == null) {
            throw new IllegalStateException("No image has been loaded yet.");
        }
        return this.container.getHeight();
    }
}

