/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite.support.image.ops;

import android.graphics.Bitmap;
import android.graphics.PointF;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.tensorflow.lite.support.common.internal.SupportPreconditions;
import org.tensorflow.lite.support.image.ColorSpaceType;
import org.tensorflow.lite.support.image.ImageOperator;
import org.tensorflow.lite.support.image.TensorImage;

public class ResizeOp
implements ImageOperator {
    private final int targetHeight;
    private final int targetWidth;
    private final boolean useBilinear;

    public ResizeOp(int targetHeight, int targetWidth, ResizeMethod resizeMethod) {
        this.targetHeight = targetHeight;
        this.targetWidth = targetWidth;
        this.useBilinear = resizeMethod == ResizeMethod.BILINEAR;
    }

    @Override
    public @NonNull TensorImage apply(@NonNull TensorImage image) {
        SupportPreconditions.checkArgument(image.getColorSpaceType() == ColorSpaceType.RGB, "Only RGB images are supported in ResizeOp, but not " + image.getColorSpaceType().name());
        Bitmap scaled = Bitmap.createScaledBitmap((Bitmap)image.getBitmap(), (int)this.targetWidth, (int)this.targetHeight, (boolean)this.useBilinear);
        image.load(scaled);
        return image;
    }

    @Override
    public int getOutputImageHeight(int inputImageHeight, int inputImageWidth) {
        return this.targetHeight;
    }

    @Override
    public int getOutputImageWidth(int inputImageHeight, int inputImageWidth) {
        return this.targetWidth;
    }

    @Override
    public PointF inverseTransform(PointF point, int inputImageHeight, int inputImageWidth) {
        return new PointF(point.x * (float)inputImageWidth / (float)this.targetWidth, point.y * (float)inputImageHeight / (float)this.targetHeight);
    }

    public static enum ResizeMethod {
        BILINEAR,
        NEAREST_NEIGHBOR;

    }
}

