/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite.support.image.ops;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.PointF;
import android.graphics.Rect;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.tensorflow.lite.support.common.internal.SupportPreconditions;
import org.tensorflow.lite.support.image.ColorSpaceType;
import org.tensorflow.lite.support.image.ImageOperator;
import org.tensorflow.lite.support.image.TensorImage;

public class ResizeWithCropOrPadOp
implements ImageOperator {
    private final int targetHeight;
    private final int targetWidth;
    private final Bitmap output;

    public ResizeWithCropOrPadOp(int targetHeight, int targetWidth) {
        this.targetHeight = targetHeight;
        this.targetWidth = targetWidth;
        this.output = Bitmap.createBitmap((int)this.targetWidth, (int)this.targetHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
    }

    @Override
    public @NonNull TensorImage apply(@NonNull TensorImage image) {
        int dstB;
        int dstT;
        int srcB;
        int srcT;
        int dstR;
        int dstL;
        int srcR;
        int srcL;
        SupportPreconditions.checkArgument(image.getColorSpaceType() == ColorSpaceType.RGB, "Only RGB images are supported in ResizeWithCropOrPadOp, but not " + image.getColorSpaceType().name());
        Bitmap input = image.getBitmap();
        int w = input.getWidth();
        int h = input.getHeight();
        if (this.targetWidth > w) {
            srcL = 0;
            srcR = w;
            dstL = (this.targetWidth - w) / 2;
            dstR = dstL + w;
        } else {
            dstL = 0;
            dstR = this.targetWidth;
            srcL = (w - this.targetWidth) / 2;
            srcR = srcL + this.targetWidth;
        }
        if (this.targetHeight > h) {
            srcT = 0;
            srcB = h;
            dstT = (this.targetHeight - h) / 2;
            dstB = dstT + h;
        } else {
            dstT = 0;
            dstB = this.targetHeight;
            srcT = (h - this.targetHeight) / 2;
            srcB = srcT + this.targetHeight;
        }
        Rect src = new Rect(srcL, srcT, srcR, srcB);
        Rect dst = new Rect(dstL, dstT, dstR, dstB);
        new Canvas(this.output).drawBitmap(input, src, dst, null);
        image.load(this.output);
        return image;
    }

    @Override
    public int getOutputImageHeight(int inputImageHeight, int inputImageWidth) {
        return this.targetHeight;
    }

    @Override
    public int getOutputImageWidth(int inputImageHeight, int inputImageWidth) {
        return this.targetWidth;
    }

    @Override
    public PointF inverseTransform(PointF point, int inputImageHeight, int inputImageWidth) {
        return ResizeWithCropOrPadOp.transformImpl(point, this.targetHeight, this.targetWidth, inputImageHeight, inputImageWidth);
    }

    private static PointF transformImpl(PointF point, int srcH, int srcW, int dstH, int dstW) {
        return new PointF(point.x + (float)((dstW - srcW) / 2), point.y + (float)((dstH - srcH) / 2));
    }
}

