/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite.support.image.ops;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.PointF;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.tensorflow.lite.support.common.internal.SupportPreconditions;
import org.tensorflow.lite.support.image.ColorSpaceType;
import org.tensorflow.lite.support.image.ImageOperator;
import org.tensorflow.lite.support.image.TensorImage;

public class Rot90Op
implements ImageOperator {
    private final int numRotation;

    public Rot90Op() {
        this(1);
    }

    public Rot90Op(int k) {
        this.numRotation = k % 4;
    }

    @Override
    public @NonNull TensorImage apply(@NonNull TensorImage image) {
        SupportPreconditions.checkArgument(image.getColorSpaceType() == ColorSpaceType.RGB, "Only RGB images are supported in Rot90Op, but not " + image.getColorSpaceType().name());
        Bitmap input = image.getBitmap();
        if (this.numRotation == 0) {
            return image;
        }
        int w = input.getWidth();
        int h = input.getHeight();
        Matrix matrix = new Matrix();
        matrix.postTranslate((float)w * 0.5f, (float)h * 0.5f);
        matrix.postRotate((float)(-90 * this.numRotation));
        int newW = this.numRotation % 2 == 0 ? w : h;
        int newH = this.numRotation % 2 == 0 ? h : w;
        matrix.postTranslate((float)newW * 0.5f, (float)newH * 0.5f);
        Bitmap output = Bitmap.createBitmap((Bitmap)input, (int)0, (int)0, (int)w, (int)h, (Matrix)matrix, (boolean)false);
        image.load(output);
        return image;
    }

    @Override
    public int getOutputImageHeight(int inputImageHeight, int inputImageWidth) {
        return this.numRotation % 2 == 0 ? inputImageHeight : inputImageWidth;
    }

    @Override
    public int getOutputImageWidth(int inputImageHeight, int inputImageWidth) {
        return this.numRotation % 2 == 0 ? inputImageWidth : inputImageHeight;
    }

    @Override
    public PointF inverseTransform(PointF point, int inputImageHeight, int inputImageWidth) {
        int inverseNumRotation = (4 - this.numRotation) % 4;
        int height = this.getOutputImageHeight(inputImageHeight, inputImageWidth);
        int width = this.getOutputImageWidth(inputImageHeight, inputImageWidth);
        return Rot90Op.transformImpl(point, height, width, inverseNumRotation);
    }

    private static PointF transformImpl(PointF point, int height, int width, int numRotation) {
        if (numRotation == 0) {
            return point;
        }
        if (numRotation == 1) {
            return new PointF(point.y, (float)width - point.x);
        }
        if (numRotation == 2) {
            return new PointF((float)width - point.x, (float)height - point.y);
        }
        return new PointF((float)height - point.y, point.x);
    }
}

