/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite.support.image.ops;

import android.graphics.PointF;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.tensorflow.lite.support.common.TensorOperator;
import org.tensorflow.lite.support.common.internal.SupportPreconditions;
import org.tensorflow.lite.support.image.ColorSpaceType;
import org.tensorflow.lite.support.image.ImageOperator;
import org.tensorflow.lite.support.image.TensorImage;
import org.tensorflow.lite.support.tensorbuffer.TensorBuffer;

public class TensorOperatorWrapper
implements ImageOperator {
    private final TensorOperator tensorOp;

    public TensorOperatorWrapper(TensorOperator op) {
        this.tensorOp = op;
    }

    @Override
    public @NonNull TensorImage apply(@NonNull TensorImage image) {
        SupportPreconditions.checkNotNull(image, "Op cannot apply on null image.");
        TensorBuffer resBuffer = this.tensorOp.apply(image.getTensorBuffer());
        ColorSpaceType colorSpaceType = image.getColorSpaceType();
        TensorImage resImage = new TensorImage(resBuffer.getDataType());
        resImage.load(resBuffer, colorSpaceType);
        return resImage;
    }

    @Override
    public int getOutputImageHeight(int inputImageHeight, int inputImageWidth) {
        return inputImageHeight;
    }

    @Override
    public int getOutputImageWidth(int inputImageHeight, int inputImageWidth) {
        return inputImageWidth;
    }

    @Override
    public PointF inverseTransform(PointF point, int inputImageHeight, int inputImageWidth) {
        return point;
    }
}

