/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite.support.image.ops;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.Paint;
import android.graphics.PointF;
import org.tensorflow.lite.support.common.internal.SupportPreconditions;
import org.tensorflow.lite.support.image.ColorSpaceType;
import org.tensorflow.lite.support.image.ImageOperator;
import org.tensorflow.lite.support.image.TensorImage;
import org.tensorflow.lite.support.tensorbuffer.TensorBuffer;

public class TransformToGrayscaleOp
implements ImageOperator {
    private static final float[] BITMAP_RGBA_GRAYSCALE_TRANSFORMATION = new float[]{0.299f, 0.587f, 0.114f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f};

    @Override
    public TensorImage apply(TensorImage image) {
        if (image.getColorSpaceType() == ColorSpaceType.GRAYSCALE) {
            return image;
        }
        SupportPreconditions.checkArgument(image.getColorSpaceType() == ColorSpaceType.RGB, "Only RGB images are supported in TransformToGrayscaleOp, but not " + image.getColorSpaceType().name());
        int h = image.getHeight();
        int w = image.getWidth();
        Bitmap bmpGrayscale = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bmpGrayscale);
        Paint paint = new Paint();
        ColorMatrixColorFilter colorMatrixFilter = new ColorMatrixColorFilter(BITMAP_RGBA_GRAYSCALE_TRANSFORMATION);
        paint.setColorFilter((ColorFilter)colorMatrixFilter);
        canvas.drawBitmap(image.getBitmap(), 0.0f, 0.0f, paint);
        int[] intValues = new int[w * h];
        bmpGrayscale.getPixels(intValues, 0, w, 0, 0, w, h);
        int[] shape = new int[]{1, h, w, 1};
        for (int i = 0; i < intValues.length; ++i) {
            intValues[i] = intValues[i] >> 16 & 0xFF;
        }
        TensorBuffer buffer = TensorBuffer.createFixedSize(shape, image.getDataType());
        buffer.loadArray(intValues, shape);
        image.load(buffer, ColorSpaceType.GRAYSCALE);
        return image;
    }

    @Override
    public int getOutputImageHeight(int inputImageHeight, int inputImageWidth) {
        return inputImageHeight;
    }

    @Override
    public int getOutputImageWidth(int inputImageHeight, int inputImageWidth) {
        return inputImageWidth;
    }

    @Override
    public PointF inverseTransform(PointF point, int inputImageHeight, int inputImageWidth) {
        return point;
    }
}

