/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite.support.label;

import java.util.Objects;
import org.tensorflow.lite.annotations.UsedByReflection;

@UsedByReflection(value="TFLiteSupport/Task")
public final class Category {
    private static final int DEFAULT_INDEX = -1;
    private static final float TOLERANCE = 1.0E-6f;
    private final int index;
    private final String label;
    private final String displayName;
    private final float score;

    @UsedByReflection(value="TFLiteSupport/Task")
    public static Category create(String label, String displayName, float score, int index) {
        return new Category(label, displayName, score, index);
    }

    @UsedByReflection(value="TFLiteSupport/Task")
    public static Category create(String label, String displayName, float score) {
        return new Category(label, displayName, score, -1);
    }

    @UsedByReflection(value="TFLiteSupport/Task")
    public Category(String label, float score) {
        this(label, "", score, -1);
    }

    private Category(String label, String displayName, float score, int index) {
        this.label = label;
        this.displayName = displayName;
        this.score = score;
        this.index = index;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public float getScore() {
        return this.score;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean equals(Object o) {
        if (o instanceof Category) {
            Category other = (Category)o;
            return other.getLabel().equals(this.label) && other.getDisplayName().equals(this.displayName) && Math.abs(other.getScore() - this.score) < 1.0E-6f && other.getIndex() == this.index;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.label, this.displayName, Float.valueOf(this.score), this.index);
    }

    public String toString() {
        return "<Category \"" + this.label + "\" (displayName=" + this.displayName + " score=" + this.score + " index=" + this.index + ")>";
    }
}

