/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite.support.label;

import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.tensorflow.lite.support.common.internal.SupportPreconditions;
import org.tensorflow.lite.support.tensorbuffer.TensorBuffer;

public class LabelUtil {
    public static List<String> mapValueToLabels(@NonNull TensorBuffer tensorBuffer, @NonNull List<String> labels, int offset) {
        SupportPreconditions.checkNotNull(tensorBuffer, "Given tensor should not be null");
        SupportPreconditions.checkNotNull(labels, "Given labels should not be null");
        int[] values = tensorBuffer.getIntArray();
        ArrayList<String> result = new ArrayList<String>();
        for (int v : values) {
            int index = v + offset;
            if (index < 0 || index >= labels.size()) {
                result.add("");
                continue;
            }
            result.add(labels.get(index));
        }
        return result;
    }

    private LabelUtil() {
    }
}

