/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite.support.label.ops;

import android.content.Context;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.tensorflow.lite.support.common.FileUtil;
import org.tensorflow.lite.support.common.internal.SupportPreconditions;
import org.tensorflow.lite.support.label.TensorLabel;
import org.tensorflow.lite.support.tensorbuffer.TensorBuffer;

public class LabelAxisOp {
    private final Map<Integer, List<String>> axisLabels;

    protected LabelAxisOp(Builder builder) {
        this.axisLabels = builder.axisLabels;
    }

    public TensorLabel apply(@NonNull TensorBuffer buffer) {
        SupportPreconditions.checkNotNull(buffer, "Tensor buffer cannot be null.");
        return new TensorLabel(this.axisLabels, buffer);
    }

    public static class Builder {
        private final Map<Integer, List<String>> axisLabels = new HashMap<Integer, List<String>>();

        protected Builder() {
        }

        public Builder addAxisLabel(@NonNull Context context, int axis, @NonNull String filePath) throws IOException {
            SupportPreconditions.checkNotNull(context, "Context cannot be null.");
            SupportPreconditions.checkNotNull(filePath, "File path cannot be null.");
            List<String> labels = FileUtil.loadLabels(context, filePath);
            this.axisLabels.put(axis, labels);
            return this;
        }

        public Builder addAxisLabel(int axis, @NonNull List<String> labels) {
            this.axisLabels.put(axis, labels);
            return this;
        }

        public LabelAxisOp build() {
            return new LabelAxisOp(this);
        }
    }
}

