/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite.support.model;

import android.util.Log;
import java.io.Closeable;
import java.io.IOException;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.tensorflow.lite.Delegate;

class GpuDelegateProxy
implements Delegate,
Closeable {
    private static final String TAG = "GpuDelegateProxy";
    private final Delegate proxiedDelegate;
    private final Closeable proxiedCloseable;

    public static @Nullable GpuDelegateProxy maybeNewInstance() {
        try {
            Class<?> clazz = Class.forName("org.tensorflow.lite.gpu.GpuDelegate");
            Object instance = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return new GpuDelegateProxy(instance);
        }
        catch (ReflectiveOperationException e) {
            Log.e((String)TAG, (String)"Failed to create the GpuDelegate dynamically.", (Throwable)e);
            return null;
        }
    }

    @Override
    public void close() {
        try {
            this.proxiedCloseable.close();
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"Failed to close the GpuDelegate.", (Throwable)e);
        }
    }

    public long getNativeHandle() {
        return this.proxiedDelegate.getNativeHandle();
    }

    private GpuDelegateProxy(Object instance) {
        this.proxiedCloseable = (Closeable)instance;
        this.proxiedDelegate = (Delegate)instance;
    }
}

