/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite.support.model;

import android.content.Context;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.tensorflow.lite.Delegate;
import org.tensorflow.lite.InterpreterApi;
import org.tensorflow.lite.Tensor;
import org.tensorflow.lite.support.common.FileUtil;
import org.tensorflow.lite.support.common.internal.SupportPreconditions;
import org.tensorflow.lite.support.model.GpuDelegateProxy;

public class Model {
    private final InterpreterApi interpreter;
    private final String modelPath;
    private final MappedByteBuffer byteModel;
    private final GpuDelegateProxy gpuDelegateProxy;

    public static Model createModel(@NonNull Context context, @NonNull String modelPath) throws IOException {
        return Model.createModel(context, modelPath, new Options.Builder().build());
    }

    public static Model createModel(@NonNull Context context, @NonNull String modelPath, @NonNull Options options) throws IOException {
        SupportPreconditions.checkNotEmpty(modelPath, "Model path in the asset folder cannot be empty.");
        MappedByteBuffer byteModel = FileUtil.loadMappedFile(context, modelPath);
        return Model.createModel(byteModel, modelPath, options);
    }

    public static Model createModel(@NonNull MappedByteBuffer byteModel, @NonNull String modelPath, @NonNull Options options) {
        InterpreterApi.Options interpreterOptions = new InterpreterApi.Options();
        GpuDelegateProxy gpuDelegateProxy = null;
        switch (options.device) {
            case NNAPI: {
                interpreterOptions.setUseNNAPI(true);
                break;
            }
            case GPU: {
                gpuDelegateProxy = GpuDelegateProxy.maybeNewInstance();
                SupportPreconditions.checkArgument(gpuDelegateProxy != null, "Cannot inference with GPU. Did you add \"tensorflow-lite-gpu\" as dependency?");
                interpreterOptions.addDelegate((Delegate)gpuDelegateProxy);
                break;
            }
        }
        interpreterOptions.setNumThreads(options.numThreads);
        if (options.tfLiteRuntime != null) {
            interpreterOptions.setRuntime(options.tfLiteRuntime);
        }
        InterpreterApi interpreter = InterpreterApi.create((ByteBuffer)byteModel, (InterpreterApi.Options)interpreterOptions);
        return new Model(modelPath, byteModel, interpreter, gpuDelegateProxy);
    }

    public @NonNull MappedByteBuffer getData() {
        return this.byteModel;
    }

    public @NonNull String getPath() {
        return this.modelPath;
    }

    public Tensor getInputTensor(int inputIndex) {
        return this.interpreter.getInputTensor(inputIndex);
    }

    public Tensor getOutputTensor(int outputIndex) {
        return this.interpreter.getOutputTensor(outputIndex);
    }

    public int[] getOutputTensorShape(int outputIndex) {
        return this.interpreter.getOutputTensor(outputIndex).shape();
    }

    public void run(@NonNull Object[] inputs, @NonNull Map<Integer, Object> outputs) {
        this.interpreter.runForMultipleInputsOutputs(inputs, outputs);
    }

    public void close() {
        if (this.interpreter != null) {
            this.interpreter.close();
        }
        if (this.gpuDelegateProxy != null) {
            this.gpuDelegateProxy.close();
        }
    }

    private Model(@NonNull String modelPath, @NonNull MappedByteBuffer byteModel, @NonNull InterpreterApi interpreter, @Nullable GpuDelegateProxy gpuDelegateProxy) {
        this.modelPath = modelPath;
        this.byteModel = byteModel;
        this.interpreter = interpreter;
        this.gpuDelegateProxy = gpuDelegateProxy;
    }

    @Deprecated
    public static class Builder {
        private Device device = Device.CPU;
        private int numThreads = 1;
        private final String modelPath;
        private final MappedByteBuffer byteModel;

        public Builder(@NonNull Context context, @NonNull String modelPath) throws IOException {
            this.modelPath = modelPath;
            this.byteModel = FileUtil.loadMappedFile(context, modelPath);
        }

        public @NonNull Builder setDevice(Device device) {
            this.device = device;
            return this;
        }

        public @NonNull Builder setNumThreads(int numThreads) {
            this.numThreads = numThreads;
            return this;
        }

        public @NonNull Model build() {
            Options options = new Options.Builder().setNumThreads(this.numThreads).setDevice(this.device).build();
            return Model.createModel(this.byteModel, this.modelPath, options);
        }
    }

    public static class Options {
        private final Device device;
        private final int numThreads;
        private final InterpreterApi.Options.TfLiteRuntime tfLiteRuntime;

        private Options(Builder builder) {
            this.device = builder.device;
            this.numThreads = builder.numThreads;
            this.tfLiteRuntime = builder.tfLiteRuntime;
        }

        public static class Builder {
            private Device device = Device.CPU;
            private int numThreads = 1;
            private InterpreterApi.Options.TfLiteRuntime tfLiteRuntime;

            public Builder setDevice(Device device) {
                this.device = device;
                return this;
            }

            public Builder setNumThreads(int numThreads) {
                this.numThreads = numThreads;
                return this;
            }

            public Builder setTfLiteRuntime(InterpreterApi.Options.TfLiteRuntime tfLiteRuntime) {
                this.tfLiteRuntime = tfLiteRuntime;
                return this;
            }

            public Options build() {
                return new Options(this);
            }
        }
    }

    public static enum Device {
        CPU,
        NNAPI,
        GPU;

    }
}

