/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite.support.tensorbuffer;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.tensorflow.lite.DataType;
import org.tensorflow.lite.support.common.internal.SupportPreconditions;
import org.tensorflow.lite.support.tensorbuffer.TensorBufferFloat;
import org.tensorflow.lite.support.tensorbuffer.TensorBufferUint8;

public abstract class TensorBuffer {
    protected ByteBuffer buffer;
    protected int[] shape;
    protected int flatSize = -1;
    protected final boolean isDynamic;

    public static @NonNull TensorBuffer createFixedSize(@NonNull int[] shape, DataType dataType) {
        switch (dataType) {
            case FLOAT32: {
                return new TensorBufferFloat(shape);
            }
            case UINT8: {
                return new TensorBufferUint8(shape);
            }
        }
        throw new AssertionError((Object)("TensorBuffer does not support data type: " + dataType));
    }

    public static @NonNull TensorBuffer createDynamic(DataType dataType) {
        switch (dataType) {
            case FLOAT32: {
                return new TensorBufferFloat();
            }
            case UINT8: {
                return new TensorBufferUint8();
            }
        }
        throw new AssertionError((Object)("TensorBuffer does not support data type: " + dataType));
    }

    public static @NonNull TensorBuffer createFrom(@NonNull TensorBuffer buffer, DataType dataType) {
        SupportPreconditions.checkNotNull(buffer, "Cannot create a buffer from null");
        TensorBuffer result = buffer.isDynamic() ? TensorBuffer.createDynamic(dataType) : TensorBuffer.createFixedSize(buffer.shape, dataType);
        if (buffer.getDataType() == DataType.FLOAT32 && dataType == DataType.FLOAT32) {
            float[] data = buffer.getFloatArray();
            result.loadArray(data, buffer.shape);
        } else {
            int[] data = buffer.getIntArray();
            result.loadArray(data, buffer.shape);
        }
        return result;
    }

    public @NonNull ByteBuffer getBuffer() {
        return this.buffer;
    }

    public int getFlatSize() {
        this.assertShapeIsCorrect();
        return this.flatSize;
    }

    public @NonNull int[] getShape() {
        this.assertShapeIsCorrect();
        return Arrays.copyOf(this.shape, this.shape.length);
    }

    public abstract DataType getDataType();

    public abstract @NonNull float[] getFloatArray();

    public abstract float getFloatValue(int var1);

    public abstract @NonNull int[] getIntArray();

    public abstract int getIntValue(int var1);

    public abstract int getTypeSize();

    public boolean isDynamic() {
        return this.isDynamic;
    }

    public abstract void loadArray(@NonNull int[] var1, @NonNull int[] var2);

    public void loadArray(@NonNull int[] src) {
        this.loadArray(src, this.shape);
    }

    public abstract void loadArray(@NonNull float[] var1, @NonNull int[] var2);

    public void loadArray(@NonNull float[] src) {
        this.loadArray(src, this.shape);
    }

    public void loadBuffer(@NonNull ByteBuffer buffer, @NonNull int[] shape) {
        SupportPreconditions.checkNotNull(buffer, "Byte buffer cannot be null.");
        SupportPreconditions.checkArgument(TensorBuffer.isShapeValid(shape), "Values in TensorBuffer shape should be non-negative.");
        int flatSize = TensorBuffer.computeFlatSize(shape);
        SupportPreconditions.checkArgument(buffer.limit() == this.getTypeSize() * flatSize, "The size of byte buffer and the shape do not match. Expected: " + this.getTypeSize() * flatSize + " Actual: " + buffer.limit());
        if (!this.isDynamic) {
            SupportPreconditions.checkArgument(Arrays.equals(shape, this.shape));
        }
        this.shape = (int[])shape.clone();
        this.flatSize = flatSize;
        buffer.rewind();
        this.buffer = buffer;
    }

    public void loadBuffer(@NonNull ByteBuffer buffer) {
        this.loadBuffer(buffer, this.shape);
    }

    protected TensorBuffer(@NonNull int[] shape) {
        this.isDynamic = false;
        this.allocateMemory(shape);
    }

    protected TensorBuffer() {
        this.isDynamic = true;
        this.allocateMemory(new int[]{0});
    }

    protected static int computeFlatSize(@NonNull int[] shape) {
        SupportPreconditions.checkNotNull(shape, "Shape cannot be null.");
        int prod = 1;
        for (int s : shape) {
            prod *= s;
        }
        return prod;
    }

    protected void resize(@NonNull int[] shape) {
        if (this.isDynamic) {
            this.allocateMemory(shape);
        } else {
            SupportPreconditions.checkArgument(Arrays.equals(shape, this.shape));
            this.shape = (int[])shape.clone();
        }
    }

    protected synchronized void copyByteBufferIfReadOnly() {
        if (!this.buffer.isReadOnly()) {
            return;
        }
        ByteBuffer newByteBuffer = ByteBuffer.allocateDirect(this.buffer.capacity());
        newByteBuffer.order(this.buffer.order());
        newByteBuffer.put(this.buffer);
        newByteBuffer.rewind();
        this.buffer = newByteBuffer;
    }

    private void allocateMemory(@NonNull int[] shape) {
        SupportPreconditions.checkNotNull(shape, "TensorBuffer shape cannot be null.");
        SupportPreconditions.checkArgument(TensorBuffer.isShapeValid(shape), "Values in TensorBuffer shape should be non-negative.");
        int newFlatSize = TensorBuffer.computeFlatSize(shape);
        this.shape = (int[])shape.clone();
        if (this.flatSize == newFlatSize) {
            return;
        }
        this.flatSize = newFlatSize;
        this.buffer = ByteBuffer.allocateDirect(this.flatSize * this.getTypeSize());
        this.buffer.order(ByteOrder.nativeOrder());
    }

    private void assertShapeIsCorrect() {
        int flatSize = TensorBuffer.computeFlatSize(this.shape);
        SupportPreconditions.checkState(this.buffer.limit() == this.getTypeSize() * flatSize, String.format("The size of underlying ByteBuffer (%d) and the shape (%s) do not match. The ByteBuffer may have been changed.", this.buffer.limit(), Arrays.toString(this.shape)));
    }

    private static boolean isShapeValid(@NonNull int[] shape) {
        if (shape.length == 0) {
            return true;
        }
        for (int s : shape) {
            if (s >= 0) continue;
            return false;
        }
        return true;
    }
}

