/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite.support.tensorbuffer;

import java.nio.FloatBuffer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.tensorflow.lite.DataType;
import org.tensorflow.lite.support.common.internal.SupportPreconditions;
import org.tensorflow.lite.support.tensorbuffer.TensorBuffer;

public final class TensorBufferFloat
extends TensorBuffer {
    private static final DataType DATA_TYPE = DataType.FLOAT32;

    TensorBufferFloat(@NonNull int[] shape) {
        super(shape);
    }

    TensorBufferFloat() {
    }

    @Override
    public DataType getDataType() {
        return DATA_TYPE;
    }

    @Override
    public @NonNull float[] getFloatArray() {
        this.buffer.rewind();
        float[] arr = new float[this.flatSize];
        FloatBuffer floatBuffer = this.buffer.asFloatBuffer();
        floatBuffer.get(arr);
        return arr;
    }

    @Override
    public float getFloatValue(int absIndex) {
        return this.buffer.getFloat(absIndex << 2);
    }

    @Override
    public @NonNull int[] getIntArray() {
        this.buffer.rewind();
        float[] floatArr = new float[this.flatSize];
        this.buffer.asFloatBuffer().get(floatArr);
        int[] intArr = new int[this.flatSize];
        for (int i = 0; i < this.flatSize; ++i) {
            intArr[i] = (int)floatArr[i];
        }
        return intArr;
    }

    @Override
    public int getIntValue(int absIndex) {
        return (int)this.buffer.getFloat(absIndex << 2);
    }

    @Override
    public int getTypeSize() {
        return DATA_TYPE.byteSize();
    }

    @Override
    public void loadArray(@NonNull float[] src, @NonNull int[] shape) {
        SupportPreconditions.checkNotNull(src, "The array to be loaded cannot be null.");
        SupportPreconditions.checkArgument(src.length == TensorBufferFloat.computeFlatSize(shape), "The size of the array to be loaded does not match the specified shape.");
        this.copyByteBufferIfReadOnly();
        this.resize(shape);
        this.buffer.rewind();
        FloatBuffer floatBuffer = this.buffer.asFloatBuffer();
        floatBuffer.put(src);
    }

    @Override
    public void loadArray(@NonNull int[] src, @NonNull int[] shape) {
        SupportPreconditions.checkNotNull(src, "The array to be loaded cannot be null.");
        SupportPreconditions.checkArgument(src.length == TensorBufferFloat.computeFlatSize(shape), "The size of the array to be loaded does not match the specified shape.");
        this.copyByteBufferIfReadOnly();
        this.resize(shape);
        this.buffer.rewind();
        float[] floatArray = new float[src.length];
        int cnt = 0;
        for (int a : src) {
            floatArray[cnt++] = a;
        }
        this.buffer.asFloatBuffer().put(floatArray);
    }
}

