/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite.support.tensorbuffer;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.tensorflow.lite.DataType;
import org.tensorflow.lite.support.common.internal.SupportPreconditions;
import org.tensorflow.lite.support.tensorbuffer.TensorBuffer;

public final class TensorBufferUint8
extends TensorBuffer {
    private static final DataType DATA_TYPE = DataType.UINT8;

    TensorBufferUint8(@NonNull int[] shape) {
        super(shape);
    }

    TensorBufferUint8() {
    }

    @Override
    public DataType getDataType() {
        return DATA_TYPE;
    }

    @Override
    public @NonNull float[] getFloatArray() {
        this.buffer.rewind();
        byte[] byteArr = new byte[this.flatSize];
        this.buffer.get(byteArr);
        float[] floatArr = new float[this.flatSize];
        for (int i = 0; i < this.flatSize; ++i) {
            floatArr[i] = byteArr[i] & 0xFF;
        }
        return floatArr;
    }

    @Override
    public float getFloatValue(int index) {
        return this.buffer.get(index) & 0xFF;
    }

    @Override
    public @NonNull int[] getIntArray() {
        this.buffer.rewind();
        byte[] byteArr = new byte[this.flatSize];
        this.buffer.get(byteArr);
        int[] intArr = new int[this.flatSize];
        for (int i = 0; i < this.flatSize; ++i) {
            intArr[i] = byteArr[i] & 0xFF;
        }
        return intArr;
    }

    @Override
    public int getIntValue(int index) {
        return this.buffer.get(index) & 0xFF;
    }

    @Override
    public int getTypeSize() {
        return DATA_TYPE.byteSize();
    }

    @Override
    public void loadArray(@NonNull float[] src, @NonNull int[] shape) {
        SupportPreconditions.checkNotNull(src, "The array to be loaded cannot be null.");
        SupportPreconditions.checkArgument(src.length == TensorBufferUint8.computeFlatSize(shape), "The size of the array to be loaded does not match the specified shape.");
        this.copyByteBufferIfReadOnly();
        this.resize(shape);
        this.buffer.rewind();
        byte[] byteArr = new byte[src.length];
        int cnt = 0;
        for (float a : src) {
            byteArr[cnt++] = (byte)Math.max(Math.min((double)a, 255.0), 0.0);
        }
        this.buffer.put(byteArr);
    }

    @Override
    public void loadArray(@NonNull int[] src, @NonNull int[] shape) {
        SupportPreconditions.checkNotNull(src, "The array to be loaded cannot be null.");
        SupportPreconditions.checkArgument(src.length == TensorBufferUint8.computeFlatSize(shape), "The size of the array to be loaded does not match the specified shape.");
        this.copyByteBufferIfReadOnly();
        this.resize(shape);
        this.buffer.rewind();
        byte[] byteArr = new byte[src.length];
        int cnt = 0;
        int[] nArray = src;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            float a = nArray[i];
            byteArr[cnt++] = (byte)Math.max(Math.min(a, 255.0f), 0.0f);
        }
        this.buffer.put(byteArr);
    }
}

