/*
 * Decompiled with CFR 0.152.
 */
package io.github.goto1134.structurizr.export.d2;

import com.structurizr.export.AbstractDiagramExporter;
import com.structurizr.export.Diagram;
import com.structurizr.export.IndentingWriter;
import com.structurizr.model.Container;
import com.structurizr.model.DeploymentNode;
import com.structurizr.model.Element;
import com.structurizr.model.GroupableElement;
import com.structurizr.model.InteractionStyle;
import com.structurizr.model.Location;
import com.structurizr.model.Person;
import com.structurizr.model.Relationship;
import com.structurizr.model.SoftwareSystem;
import com.structurizr.view.AutomaticLayout;
import com.structurizr.view.ComponentView;
import com.structurizr.view.Configuration;
import com.structurizr.view.ContainerView;
import com.structurizr.view.DeploymentView;
import com.structurizr.view.DynamicView;
import com.structurizr.view.ElementStyle;
import com.structurizr.view.LineStyle;
import com.structurizr.view.MetadataSymbols;
import com.structurizr.view.RelationshipStyle;
import com.structurizr.view.RelationshipView;
import com.structurizr.view.Shape;
import com.structurizr.view.SystemContextView;
import com.structurizr.view.SystemLandscapeView;
import com.structurizr.view.View;
import io.github.goto1134.structurizr.export.d2.D2Diagram;
import io.github.goto1134.structurizr.export.d2.model.D2Connection;
import io.github.goto1134.structurizr.export.d2.model.D2Direction;
import io.github.goto1134.structurizr.export.d2.model.D2Keyword;
import io.github.goto1134.structurizr.export.d2.model.D2Object;
import io.github.goto1134.structurizr.export.d2.model.D2Property;
import io.github.goto1134.structurizr.export.d2.model.D2Shape;
import java.util.LinkedList;
import java.util.Optional;
import java.util.stream.Collectors;

public class D2Exporter
extends AbstractDiagramExporter {
    public static final String D2_IGNORE_RELATION_FONT_SIZE = "d2.ignore_relation_font_size";

    protected void writeHeader(View view, IndentingWriter writer) {
        Optional.ofNullable(view.getAutomaticLayout()).map(AutomaticLayout::getRankDirection).map(it -> {
            switch (it) {
                case TopBottom: {
                    return D2Direction.TOP_TO_BOTTOM;
                }
                case BottomTop: {
                    return D2Direction.BOTTOM_TO_TOP;
                }
                case LeftRight: {
                    return D2Direction.LEFT_TO_RIGHT;
                }
                case RightLeft: {
                    return D2Direction.RIGHT_TO_LEFT;
                }
            }
            throw new IllegalStateException("Unexpected value: " + it);
        }).map(it -> new D2Property<D2Keyword, D2Direction>(D2Keyword.DIRECTION, (D2Direction)((Object)it))).ifPresent(it -> it.write(writer));
    }

    protected void writeFooter(View view, IndentingWriter writer) {
    }

    protected void startEnterpriseBoundary(View view, String enterpriseName, IndentingWriter writer) {
        D2Object.builder(this.enterpriseId(enterpriseName)).label(enterpriseName).withGroupStyle().build().startObject(writer);
    }

    protected void endEnterpriseBoundary(View view, IndentingWriter writer) {
        D2Object.endObject(writer);
    }

    protected void startGroupBoundary(View view, String group, IndentingWriter writer) {
        D2Object.builder(this.groupId(group)).label(group).withGroupStyle().build().startObject(writer);
    }

    protected void endGroupBoundary(View view, IndentingWriter writer) {
        D2Object.endObject(writer);
    }

    protected void startSoftwareSystemBoundary(View view, SoftwareSystem softwareSystem, IndentingWriter writer) {
        this.getD2Object(view, (Element)softwareSystem).startObject(writer);
    }

    protected void endSoftwareSystemBoundary(View view, IndentingWriter writer) {
        D2Object.endObject(writer);
    }

    protected void startContainerBoundary(View view, Container container, IndentingWriter writer) {
        this.getD2Object(view, (Element)container).startObject(writer);
    }

    protected void endContainerBoundary(View view, IndentingWriter writer) {
        D2Object.endObject(writer);
    }

    protected void startDeploymentNodeBoundary(DeploymentView view, DeploymentNode deploymentNode, IndentingWriter writer) {
        this.getD2Object((View)view, (Element)deploymentNode).startObject(writer);
    }

    protected void endDeploymentNodeBoundary(View view, IndentingWriter writer) {
        D2Object.endObject(writer);
    }

    protected void writeElement(View view, Element element, IndentingWriter writer) {
        this.getD2Object(view, element).writeObject(writer);
    }

    protected void writeRelationship(View view, RelationshipView relationshipView, IndentingWriter writer) {
        Relationship relationship = relationshipView.getRelationship();
        RelationshipStyle relationshipStyle = this.findRelationshipStyle(view, relationshipView.getRelationship());
        D2Connection connection = Optional.ofNullable(relationshipView.isResponse()).filter(it -> it).map(it -> D2Connection.REVERSE).orElse(D2Connection.DIRECT);
        String sourceKey = this.getAbsolutePath(view, relationship.getSource());
        String destinationKey = this.getAbsolutePath(view, relationship.getDestination());
        D2Object.Builder builder = D2Object.builder(String.format("%s %s %s", new Object[]{sourceKey, connection, destinationKey})).label(this.getLabel(view, relationshipView)).opacity(relationshipStyle.getOpacity().doubleValue() / 100.0).stroke(relationshipStyle.getColor());
        if (!Boolean.parseBoolean(view.getProperties().getOrDefault(D2_IGNORE_RELATION_FONT_SIZE, "true"))) {
            builder.fontSize(relationshipStyle.getFontSize());
        }
        Optional.ofNullable(relationshipStyle.getStyle()).ifPresent(lineStyle -> {
            if (lineStyle == LineStyle.Dashed) {
                builder.dashed();
            } else if (lineStyle == LineStyle.Dotted) {
                builder.dotted();
            }
        });
        D2Object d2Object = builder.strokeWidth(relationshipStyle.getThickness()).build();
        d2Object.writeObject(writer);
    }

    protected Diagram createDiagram(View view, String definition) {
        return new D2Diagram(view, definition);
    }

    private D2Object getD2Object(View view, Element element) {
        ElementStyle elementStyle = this.findElementStyle(view, element);
        D2Object.Builder builder = D2Object.builder(this.idWithPrefix(element)).label(this.getLabel(view, element)).shape(this.d2ShapeOf(elementStyle)).icon(Optional.ofNullable(elementStyle.getIcon())).link(Optional.ofNullable(element.getUrl())).fill(elementStyle.getBackground()).stroke(elementStyle.getStroke()).strokeWidth(Optional.ofNullable(elementStyle.getStrokeWidth())).opacity(elementStyle.getOpacity().doubleValue() / 100.0);
        switch (elementStyle.getBorder()) {
            case Dashed: {
                builder.dashed();
                break;
            }
            case Dotted: {
                builder.dotted();
                break;
            }
        }
        return builder.multiple(element instanceof DeploymentNode && ((DeploymentNode)element).getInstances() > 1).fontColor(elementStyle.getColor()).fontSize(elementStyle.getFontSize()).build();
    }

    D2Shape d2ShapeOf(ElementStyle style) {
        return this.d2ShapeOf(style.getShape());
    }

    D2Shape d2ShapeOf(Shape shape) {
        switch (shape) {
            case Person: 
            case Robot: {
                return D2Shape.PERSON;
            }
            case Cylinder: {
                return D2Shape.CYLINDER;
            }
            case Folder: {
                return D2Shape.PACKAGE;
            }
            case Ellipse: {
                return D2Shape.OVAL;
            }
            case Circle: {
                return D2Shape.CIRCLE;
            }
            case Hexagon: {
                return D2Shape.HEXAGON;
            }
            case Pipe: {
                return D2Shape.QUEUE;
            }
            case Diamond: {
                return D2Shape.DIAMOND;
            }
        }
        return D2Shape.RECTANGLE;
    }

    private String getAbsolutePath(View view, Element element) {
        LinkedList<Element> pathFromParent = new LinkedList<Element>();
        do {
            pathFromParent.addFirst(element);
        } while ((element = element.getParent()) != null && (view.isElementInView(element) || view instanceof ComponentView && ((ComponentView)view).getContainer().equals(element) || view instanceof ContainerView && view.getSoftwareSystem().equals(element) || view instanceof DynamicView && ((DynamicView)view).getElement().equals(element)));
        String enterprisePrefix = this.getEnterprisePrefix(view, (Element)pathFromParent.peek());
        return pathFromParent.stream().map(it -> view.isElementInView(it) ? this.idWithGroupAndPrefix((Element)it) : this.idWithPrefix(it.getId())).collect(Collectors.joining(".", enterprisePrefix, ""));
    }

    private String getEnterprisePrefix(View view, Element parent) {
        boolean enterpriseBoundaryVisible;
        boolean bl = enterpriseBoundaryVisible = view instanceof SystemLandscapeView && ((SystemLandscapeView)view).isEnterpriseBoundaryVisible() || view instanceof SystemContextView && ((SystemContextView)view).isEnterpriseBoundaryVisible();
        if (enterpriseBoundaryVisible && (parent instanceof Person && ((Person)parent).getLocation() == Location.Internal || parent instanceof SoftwareSystem && ((SoftwareSystem)parent).getLocation() == Location.Internal)) {
            return String.format("%s.", this.enterpriseId(view.getModel().getEnterprise().getName()));
        }
        return "";
    }

    private String idWithGroupAndPrefix(Element element) {
        String idWithPrefix = this.idWithPrefix(element.getId());
        if (element instanceof GroupableElement && this.hasValue(((GroupableElement)element).getGroup())) {
            return String.format("%s.%s", this.groupId(((GroupableElement)element).getGroup()), idWithPrefix);
        }
        return idWithPrefix;
    }

    private String idWithPrefix(Element element) {
        return this.idWithPrefix(element.getId());
    }

    private String idWithPrefix(String id) {
        return String.format("container_%s", id);
    }

    private String groupId(String groupName) {
        return String.format("\"group_%s\"", groupName);
    }

    private String enterpriseId(String enterpriseName) {
        return String.format("\"enterprise_%s\"", enterpriseName);
    }

    private String getLabel(View view, Element element) {
        String typeOf = this.typeOf(view, element, true);
        if (this.hasValue(typeOf)) {
            return String.format("%s%n%s", element.getName(), typeOf);
        }
        return element.getName();
    }

    private String getLabel(View view, RelationshipView relationshipView) {
        if (this.hasValue(relationshipView.getDescription())) {
            if (this.hasValue(relationshipView.getOrder())) {
                return String.format("%s \u2013 %s", relationshipView.getOrder(), relationshipView.getDescription());
            }
            return relationshipView.getDescription();
        }
        Relationship relationship = relationshipView.getRelationship();
        String typeOf = this.typeOf(view, relationship);
        if (this.hasValue(typeOf)) {
            return String.format("%s%n%s", relationship.getDescription(), typeOf);
        }
        return relationship.getDescription();
    }

    private String typeOf(View view, Relationship relationship) {
        String typeOf = this.hasValue(relationship.getTechnology()) ? (relationship.getInteractionStyle() == InteractionStyle.Asynchronous ? String.format("Async %s", relationship.getTechnology()) : relationship.getTechnology()) : (relationship.getInteractionStyle() == InteractionStyle.Asynchronous ? "Async" : "");
        if (this.hasValue(typeOf)) {
            Configuration configuration = view.getViewSet().getConfiguration();
            if (configuration.getMetadataSymbols() == null) {
                configuration.setMetadataSymbols(MetadataSymbols.SquareBrackets);
            }
            switch (configuration.getMetadataSymbols()) {
                case RoundBrackets: {
                    return "(" + typeOf + ")";
                }
                case CurlyBrackets: {
                    return "{" + typeOf + "}";
                }
                case AngleBrackets: {
                    return "<" + typeOf + ">";
                }
                case DoubleAngleBrackets: {
                    return "<<" + typeOf + ">>";
                }
                case None: {
                    return typeOf;
                }
            }
            return "[" + typeOf + "]";
        }
        return typeOf;
    }
}

