/*
 * Decompiled with CFR 0.152.
 */
package io.github.goto1134.structurizr.export.d2.model;

import com.structurizr.export.IndentingWriter;
import io.github.goto1134.structurizr.export.d2.model.D2Keyword;
import io.github.goto1134.structurizr.export.d2.model.D2Property;
import io.github.goto1134.structurizr.export.d2.model.D2Shape;
import io.github.goto1134.structurizr.export.d2.model.D2StyleKeyword;
import io.github.goto1134.structurizr.export.d2.model.D2WrappedStringProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;

public class D2Object {
    private final String name;
    private final List<D2Property<D2Keyword, ?>> properties;
    private final List<D2Property<D2StyleKeyword, ?>> style;

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public D2Object(String name, List<D2Property<D2Keyword, ?>> properties, List<D2Property<D2StyleKeyword, ?>> style) {
        this.name = name;
        this.properties = Collections.unmodifiableList(properties);
        this.style = Collections.unmodifiableList(style);
    }

    public void startObject(IndentingWriter writer) {
        writer.writeLine(String.format("%s: {", this.name));
        writer.indent();
        this.properties.stream().sorted(Comparator.comparing(it -> ((D2Keyword)((Object)((Object)it.getKeyword()))).toString())).forEach(p -> p.write(writer));
        writer.writeLine(String.format("%s: {", new Object[]{D2Keyword.STYLE}));
        writer.indent();
        this.style.stream().sorted(Comparator.comparing(it -> ((D2StyleKeyword)((Object)((Object)it.getKeyword()))).toString())).forEach(p -> p.write(writer));
        D2Object.endObject(writer);
    }

    public void writeObject(IndentingWriter writer) {
        this.startObject(writer);
        D2Object.endObject(writer);
    }

    public static void endObject(IndentingWriter writer) {
        writer.outdent();
        writer.writeLine("}");
    }

    public static class Builder {
        public static final int STROKE_DASHED = 5;
        public static final int STROKE_DOTTED = 2;
        private final String name;
        private final List<D2Property<D2Keyword, ?>> properties = new ArrayList();
        private final List<D2Property<D2StyleKeyword, ?>> style = new ArrayList();

        public Builder(String name) {
            this.name = name;
        }

        public Builder label(String label) {
            this.properties.add(new D2WrappedStringProperty<D2Keyword>(D2Keyword.LABEL, label));
            return this;
        }

        public Builder shape(D2Shape shape) {
            this.properties.add(new D2Property<D2Keyword, D2Shape>(D2Keyword.SHAPE, shape));
            return this;
        }

        public Builder icon(Optional<String> icon) {
            icon.filter(it -> !it.isEmpty()).ifPresent(it -> this.properties.add(new D2WrappedStringProperty<D2Keyword>(D2Keyword.ICON, (String)it)));
            return this;
        }

        public Builder link(Optional<String> link) {
            link.filter(it -> !it.isEmpty()).ifPresent(it -> this.properties.add(new D2WrappedStringProperty<D2Keyword>(D2Keyword.LINK, (String)it)));
            return this;
        }

        public Builder fill(String fill) {
            this.style.add(new D2WrappedStringProperty<D2StyleKeyword>(D2StyleKeyword.FILL_COLOR, fill));
            return this;
        }

        public Builder stroke(String stroke) {
            this.style.add(new D2WrappedStringProperty<D2StyleKeyword>(D2StyleKeyword.STROKE_COLOR, stroke));
            return this;
        }

        public Builder strokeWidth(Optional<Integer> widthOptional) {
            if (widthOptional.isPresent()) {
                return this.strokeWidth(widthOptional.get());
            }
            return this;
        }

        public Builder strokeWidth(Integer width) {
            this.style.add(new D2Property<D2StyleKeyword, Integer>(D2StyleKeyword.STROKE_WIDTH, width));
            return this;
        }

        public Builder strokeDash(Integer dash) {
            this.style.add(new D2Property<D2StyleKeyword, Integer>(D2StyleKeyword.STROKE_DASH, dash));
            return this;
        }

        public Builder dashed() {
            return this.strokeDash(5);
        }

        public Builder dotted() {
            return this.strokeDash(2);
        }

        public Builder multiple(boolean value) {
            this.style.add(new D2Property<D2StyleKeyword, Boolean>(D2StyleKeyword.SHAPE_MULTIPLE, value));
            return this;
        }

        public Builder fontColor(String fontColor) {
            this.style.add(new D2WrappedStringProperty<D2StyleKeyword>(D2StyleKeyword.TEXT_FONT_COLOR, fontColor));
            return this;
        }

        public Builder fontSize(Integer fontSize) {
            this.style.add(new D2Property<D2StyleKeyword, Integer>(D2StyleKeyword.TEXT_FONT_SIZE, fontSize));
            return this;
        }

        public Builder opacity(Double opacity) {
            this.style.add(new D2Property<D2StyleKeyword, Double>(D2StyleKeyword.OPACITY, opacity));
            return this;
        }

        public Builder withGroupStyle() {
            return this.fill("white").stroke("black");
        }

        public D2Object build() {
            return new D2Object(this.name, this.properties, this.style);
        }
    }
}

