/*
 * Decompiled with CFR 0.152.
 */
package io.github.gregoryfeijon.object.factory.commons.utils;

import io.github.gregoryfeijon.object.factory.commons.exception.ApiException;
import io.github.gregoryfeijon.object.factory.commons.utils.ReflectionUtil;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Field;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.commons.lang3.reflect.FieldUtils;

public final class FieldUtil {
    public static <T> void setProtectedFieldValue(Field destField, T dest, Object sourceValue) {
        FieldUtil.validateSetterParameters(destField, dest);
        try {
            FieldUtil.setValueUsingSetter(destField, dest, sourceValue);
        }
        catch (Exception e) {
            try {
                FieldUtil.setFieldValueWithHandles(destField, dest, sourceValue);
            }
            catch (Exception ex) {
                try {
                    FieldUtil.setValueUsingFieldUtils(destField, dest, sourceValue);
                }
                catch (IllegalAccessException exc) {
                    throw new ApiException(String.format("Failed to set value for field '%s' after trying all strategies", destField.getName()), exc);
                }
            }
        }
    }

    public static Object getProtectedFieldValue(Field field, Object target) {
        FieldUtil.validateGetterParameters(field, target);
        try {
            return FieldUtil.getValueUsingGetter(field, target);
        }
        catch (Exception e) {
            try {
                return FieldUtil.getFieldValueWithHandles(field, target);
            }
            catch (Exception ex) {
                try {
                    return FieldUtil.getValueUsingFieldUtils(field, target);
                }
                catch (IllegalAccessException exc) {
                    throw new ApiException(String.format("Failed to get value from field '%s' after trying all strategies", field.getName()), exc);
                }
            }
        }
    }

    public static <T> boolean verifyNull(Supplier<T> getterValidate) {
        if (getterValidate == null) {
            throw new ApiException("Supplier cannot be null");
        }
        T value = getterValidate.get();
        return value == null;
    }

    private static <T> void setFieldValueWithHandles(Field field, T target, Object value) {
        try {
            MethodHandles.Lookup lookup = MethodHandles.privateLookupIn(target.getClass(), MethodHandles.lookup());
            VarHandle varHandle = lookup.unreflectVarHandle(field);
            varHandle.set(target, value);
        }
        catch (Exception ex) {
            throw new ApiException(String.format("VarHandle strategy failed for field '%s'", field.getName()), ex);
        }
    }

    private static Object getFieldValueWithHandles(Field field, Object target) {
        try {
            MethodHandles.Lookup lookup = MethodHandles.privateLookupIn(target.getClass(), MethodHandles.lookup());
            VarHandle varHandle = lookup.unreflectVarHandle(field);
            return varHandle.get(target);
        }
        catch (Exception ex) {
            throw new ApiException(String.format("VarHandle strategy failed for field '%s'", field.getName()), ex);
        }
    }

    private static <T> void setValueUsingSetter(Field field, T dest, Object value) throws Exception {
        ReflectionUtil.setValueDynamicallyThroughSetterNameFromField(field, dest, value);
    }

    private static Object getValueUsingGetter(Field field, Object target) throws Exception {
        return ReflectionUtil.getValueDynamicallyThroughGetterNameFromField(field, target);
    }

    private static <T> void setValueUsingFieldUtils(Field field, T dest, Object value) throws IllegalAccessException {
        FieldUtils.writeField(dest, (String)field.getName(), (Object)value, (boolean)true);
    }

    private static Object getValueUsingFieldUtils(Field field, Object target) throws IllegalAccessException {
        return FieldUtils.readField((Field)field, (Object)target, (boolean)true);
    }

    private static <T> void validateSetterParameters(Field field, T dest) {
        if (field == null) {
            throw new ApiException("Field cannot be null");
        }
        if (dest == null) {
            throw new ApiException("Destination object cannot be null");
        }
    }

    private static void validateGetterParameters(Field field, Object target) {
        if (field == null) {
            throw new ApiException("Field cannot be null");
        }
        if (target == null) {
            throw new ApiException("Target object cannot be null");
        }
    }

    @Generated
    private FieldUtil() {
    }
}

