/*
 * Decompiled with CFR 0.152.
 */
package io.github.gregoryfeijon.object.factory.commons.utils;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.sql.Time;
import java.text.Format;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.Temporal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.commons.lang3.ClassUtils;

public final class ReflectionTypeUtil {
    private static final Set<Class<?>> WRAPPER_TYPES;
    private static final Map<Class<?>, Object> DEFAULT_VALUES;
    private static final Map<Class<?>, Boolean> SIMPLE_TYPE_CACHE;
    private static final Map<Class<?>, Boolean> WRAPPER_CACHE;
    private static final Map<Class<?>, Boolean> ARRAY_PRIMITIVE_OR_WRAPPER_CACHE;

    public static Class<?> getRawType(Type genericType) throws ClassNotFoundException {
        if (genericType instanceof Class) {
            Class clazz = (Class)genericType;
            return clazz;
        }
        if (genericType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)genericType;
            Type rawType = parameterizedType.getRawType();
            return ClassUtils.getClass((String)rawType.getTypeName());
        }
        if (genericType instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)genericType;
            Class<?> componentType = ReflectionTypeUtil.getRawType(genericArrayType.getGenericComponentType());
            return Array.newInstance(componentType, 0).getClass();
        }
        if (genericType instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)genericType;
            Type[] bounds = typeVariable.getBounds();
            if (bounds.length > 0) {
                return ReflectionTypeUtil.getRawType(bounds[0]);
            }
            throw new IllegalArgumentException("TypeVariable without bounds: " + typeVariable.getName());
        }
        if (genericType instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)genericType;
            Type[] upperBounds = wildcardType.getUpperBounds();
            if (upperBounds.length > 0) {
                return ReflectionTypeUtil.getRawType(upperBounds[0]);
            }
            throw new IllegalArgumentException("WildcardType without upper bounds: " + String.valueOf(wildcardType));
        }
        throw new IllegalArgumentException("Unsupported Type implementation: " + genericType.getClass().getName());
    }

    public static boolean isPrimitiveOrEnum(Class<?> type) {
        return type.isPrimitive() || type.isEnum();
    }

    public static boolean isClassMapCollection(Class<?> clazz) {
        return ReflectionTypeUtil.isCollection(clazz) || ReflectionTypeUtil.isMap(clazz);
    }

    public static boolean isCollection(Class<?> clazz) {
        return Collection.class.isAssignableFrom(clazz);
    }

    public static boolean isMap(Class<?> clazz) {
        return Map.class.isAssignableFrom(clazz);
    }

    public static boolean isSimpleType(Class<?> clazz) {
        return SIMPLE_TYPE_CACHE.computeIfAbsent(clazz, c -> c.isPrimitive() || ReflectionTypeUtil.isWrapperType(c) || ReflectionTypeUtil.isArrayOfPrimitiveOrWrapper(c));
    }

    private static boolean isArrayOfPrimitiveOrWrapper(Class<?> clazz) {
        return ARRAY_PRIMITIVE_OR_WRAPPER_CACHE.computeIfAbsent(clazz, c -> {
            if (!c.isArray()) {
                return false;
            }
            Class<?> componentType = c.getComponentType();
            return componentType.isPrimitive() || ReflectionTypeUtil.isWrapperType(componentType);
        });
    }

    public static boolean isWrapperType(Class<?> clazz) {
        return WRAPPER_CACHE.computeIfAbsent(clazz, c -> WRAPPER_TYPES.contains(c) || WRAPPER_TYPES.stream().anyMatch(w -> w.isAssignableFrom((Class<?>)c)));
    }

    public static Set<Class<?>> getWrapperTypes() {
        HashSet wrappers = new HashSet();
        wrappers.add(Boolean.class);
        wrappers.add(Byte.class);
        wrappers.add(UUID.class);
        wrappers.addAll(ReflectionTypeUtil.numberTypes());
        wrappers.addAll(ReflectionTypeUtil.dateTypes());
        wrappers.addAll(ReflectionTypeUtil.textTypes());
        return wrappers;
    }

    public static Set<Class<?>> textTypes() {
        HashSet aux = new HashSet();
        aux.add(String.class);
        aux.add(Character.class);
        aux.add(Format.class);
        return aux;
    }

    public static Set<Class<?>> dateTypes() {
        HashSet aux = new HashSet();
        aux.add(Date.class);
        aux.add(Time.class);
        aux.add(LocalDateTime.class);
        aux.add(LocalDate.class);
        aux.add(LocalTime.class);
        aux.add(Temporal.class);
        aux.add(Instant.class);
        return aux;
    }

    public static Set<Class<?>> numberTypes() {
        HashSet aux = new HashSet();
        aux.add(Integer.class);
        aux.add(Double.class);
        aux.add(Float.class);
        aux.add(Long.class);
        aux.add(Number.class);
        return aux;
    }

    private static void initDefaultValues() {
        DEFAULT_VALUES.put(Boolean.TYPE, Boolean.FALSE);
        DEFAULT_VALUES.put(Byte.TYPE, (byte)0);
        DEFAULT_VALUES.put(Short.TYPE, (short)0);
        DEFAULT_VALUES.put(Integer.TYPE, 0);
        DEFAULT_VALUES.put(Long.TYPE, 0L);
        DEFAULT_VALUES.put(Character.TYPE, Character.valueOf('\u0000'));
        DEFAULT_VALUES.put(Float.TYPE, Float.valueOf(0.0f));
        DEFAULT_VALUES.put(Double.TYPE, 0.0);
    }

    public static <T> T defaultValueFor(Class<T> clazz) {
        return (T)DEFAULT_VALUES.get(clazz);
    }

    @Generated
    private ReflectionTypeUtil() {
    }

    static {
        DEFAULT_VALUES = new HashMap();
        SIMPLE_TYPE_CACHE = new ConcurrentHashMap();
        WRAPPER_CACHE = new ConcurrentHashMap();
        ARRAY_PRIMITIVE_OR_WRAPPER_CACHE = new ConcurrentHashMap();
        WRAPPER_TYPES = Set.copyOf(ReflectionTypeUtil.getWrapperTypes());
        ReflectionTypeUtil.initDefaultValues();
    }
}

