/*
 * Decompiled with CFR 0.152.
 */
package io.github.gregoryfeijon.object.factory.commons.utils;

import io.github.gregoryfeijon.object.factory.commons.exception.ApiException;
import io.github.gregoryfeijon.object.factory.commons.utils.ReflectionTypeUtil;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public final class ReflectionUtil {
    private static final String NULL_ENTITY_ERROR = "Entities to compare cannot be null";
    private static final String DIFFERENT_TYPES_ERROR = "Entities must be of the same type";

    public static List<Method> findGetMethods(Object object) {
        ReflectionUtil.validateObject(object, "Object to find getters");
        return ReflectionUtil.getMethodsAsList(object).stream().filter(method -> ReflectionUtil.isGetterMethod(method.getName())).collect(Collectors.toCollection(ArrayList::new));
    }

    public static List<Method> findSetMethods(Object object) {
        ReflectionUtil.validateObject(object, "Object to find setters");
        return ReflectionUtil.getMethodsAsList(object).stream().filter(method -> method.getName().toLowerCase().startsWith("set")).collect(Collectors.toCollection(ArrayList::new));
    }

    public static Collection<Method> getMethodsAsList(Object object) {
        ReflectionUtil.validateObject(object, "Object to get methods");
        return Arrays.asList(ReflectionUtils.getAllDeclaredMethods(object.getClass()));
    }

    private static boolean isGetterMethod(String methodName) {
        String lowerName = methodName.toLowerCase();
        return lowerName.startsWith("get") || lowerName.startsWith("is");
    }

    public static Collection<Field> getFieldsAsCollection(Object object) {
        return ReflectionUtil.getFieldsAsCollection(object, true);
    }

    public static <T extends Collection<Field>> T getFieldsAsCollection(Object object, Supplier<T> collectionType) {
        return (T)((Collection)ReflectionUtil.getFieldsAsCollection(object, true).stream().collect(Collectors.toCollection(collectionType)));
    }

    public static Collection<Field> getFieldsAsCollection(Object object, boolean includeParents) {
        ReflectionUtil.validateObject(object, "Object to get fields");
        Class<?> clazz = object.getClass();
        Collection fields = Arrays.stream(clazz.getDeclaredFields()).collect(Collectors.toCollection(ArrayList::new));
        if (includeParents && clazz.getSuperclass() != null) {
            for (Class<?> currentClass = clazz.getSuperclass(); currentClass != null; currentClass = currentClass.getSuperclass()) {
                fields.addAll(Arrays.asList(currentClass.getDeclaredFields()));
            }
        }
        return fields;
    }

    public static <T> boolean compareObjectsValues(T entity1, T entity2) throws InvocationTargetException, IllegalAccessException {
        ReflectionUtil.validateComparisonParameters(entity1, entity2);
        List<Method> getsEntity1 = ReflectionUtil.findGetMethods(entity1);
        List<Method> getsEntity2 = ReflectionUtil.findGetMethods(entity2);
        return ReflectionUtil.compareLists(getsEntity1, getsEntity2, entity1, entity2);
    }

    public static <T> boolean compareObjectsValues(T entity1, T entity2, String[] filterNames) throws InvocationTargetException, IllegalAccessException {
        if (filterNames == null) {
            return ReflectionUtil.compareObjectsValues(entity1, entity2);
        }
        return ReflectionUtil.compare(entity1, entity2, filterNames, true);
    }

    public static <T> boolean compareObjectsValues(T entity1, T entity2, String[] filterNames, boolean remove) throws InvocationTargetException, IllegalAccessException {
        return ReflectionUtil.compare(entity1, entity2, filterNames, remove);
    }

    private static <T> boolean compare(T entity1, T entity2, String[] filterNames, boolean remove) throws InvocationTargetException, IllegalAccessException {
        ReflectionUtil.validateComparisonParameters(entity1, entity2);
        List<Method> getsEntity1 = ReflectionUtil.findGetMethods(entity1);
        List<Method> getsEntity2 = ReflectionUtil.findGetMethods(entity2);
        getsEntity1 = ReflectionUtil.filterList(getsEntity1, filterNames, remove);
        getsEntity2 = ReflectionUtil.filterList(getsEntity2, filterNames, remove);
        return ReflectionUtil.compareLists(getsEntity1, getsEntity2, entity1, entity2);
    }

    private static boolean compareLists(List<Method> getsEntity1, List<Method> getsEntity2, Object entity1, Object entity2) throws InvocationTargetException, IllegalAccessException {
        for (Method methodEntity1 : getsEntity1) {
            Object value2;
            Object value1;
            Optional<Method> methodEntity2 = getsEntity2.stream().filter(method -> method.getName().equalsIgnoreCase(methodEntity1.getName())).findAny();
            if (!methodEntity2.isPresent() || ObjectUtils.nullSafeEquals((Object)(value1 = methodEntity1.invoke(entity1, new Object[0])), (Object)(value2 = methodEntity2.get().invoke(entity2, new Object[0])))) continue;
            if (!ReflectionUtil.areReturnTypesEqual(methodEntity1, methodEntity2.get())) {
                return false;
            }
            if (ReflectionUtil.areValuesEquivalent(value1, value2, methodEntity1.getReturnType())) continue;
            return false;
        }
        return true;
    }

    private static boolean areReturnTypesEqual(Method method1, Method method2) {
        return method1.getReturnType() == method2.getReturnType();
    }

    private static boolean areValuesEquivalent(Object value1, Object value2, Class<?> type) {
        if (type.isAssignableFrom(String.class)) {
            return ReflectionUtil.areStringsEquivalent(value1, value2);
        }
        if (type.isAssignableFrom(Integer.class) || type.isAssignableFrom(Double.class)) {
            return ReflectionUtil.areNumbersEquivalent(value1, value2);
        }
        if (type.isAssignableFrom(Collection.class)) {
            return ReflectionUtil.areCollectionsEquivalent(value1, value2);
        }
        return false;
    }

    private static boolean areStringsEquivalent(Object value1, Object value2) {
        if (value1 == null && value2 != null) {
            return ReflectionUtil.isStringEmpty(value2);
        }
        if (value2 == null && value1 != null) {
            return ReflectionUtil.isStringEmpty(value1);
        }
        return false;
    }

    private static boolean isStringEmpty(Object value) {
        return ((String)value).isEmpty();
    }

    private static boolean areNumbersEquivalent(Object value1, Object value2) {
        if (value1 == null && value2 != null) {
            return ReflectionUtil.isNumberZero(value2);
        }
        if (value2 == null && value1 != null) {
            return ReflectionUtil.isNumberZero(value1);
        }
        return false;
    }

    private static boolean isNumberZero(Object value) {
        BigDecimal decimal = BigDecimal.valueOf(((Number)value).doubleValue());
        return decimal.compareTo(BigDecimal.ZERO) == 0;
    }

    private static boolean areCollectionsEquivalent(Object value1, Object value2) {
        if (value1 == null && value2 != null) {
            return ReflectionUtil.isCollectionEmpty(value2);
        }
        if (value2 == null && value1 != null) {
            return ReflectionUtil.isCollectionEmpty(value1);
        }
        return false;
    }

    private static boolean isCollectionEmpty(Object value) {
        return CollectionUtils.isEmpty((Collection)((Collection)value));
    }

    public static List<Method> filterList(List<Method> listMethod, String[] filterNames, boolean remove) {
        ArrayList<Method> methodsFiltered = new ArrayList<Method>();
        Arrays.stream(filterNames).forEach(name -> {
            Optional<Method> methodToFilter = listMethod.stream().filter(method -> ReflectionUtil.isMethodMatchingFieldName(method, name)).findAny();
            methodToFilter.ifPresent(methodsFiltered::add);
        });
        if (!CollectionUtils.isEmpty(methodsFiltered)) {
            if (remove) {
                listMethod.removeAll(methodsFiltered);
            } else {
                return methodsFiltered;
            }
        }
        return listMethod;
    }

    private static boolean isMethodMatchingFieldName(Method method, String fieldName) {
        String methodName = method.getName();
        return methodName.equalsIgnoreCase("get" + fieldName) || methodName.equalsIgnoreCase("is" + fieldName) || methodName.equalsIgnoreCase("set" + fieldName);
    }

    public static <T, R> Optional<R> safeGet(T obj, Function<T, R> getter) {
        ReflectionUtil.validateGetter(getter);
        if (obj == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(getter.apply(obj));
    }

    public static <T, R> R safeGetWithDefaultValue(T obj, Function<T, R> getter, R defaultValue) {
        return ReflectionUtil.safeGet(obj, getter).orElse(defaultValue);
    }

    public static <T> List<T> removeNulls(List<T> list) {
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList();
        }
        return list.stream().filter(Objects::nonNull).collect(Collectors.toCollection(ArrayList::new));
    }

    public static <T> Object getValueDynamicallyThroughGetterNameFromField(Field field, T getterObject) {
        ReflectionUtil.validateField(field);
        ReflectionUtil.validateObject(getterObject, "Getter object");
        String getterPrefix = field.getType() == Boolean.TYPE ? "is" : "get";
        String getterName = getterPrefix + StringUtils.capitalize((String)field.getName());
        return ReflectionUtil.getValueDynamicallyThroughGetterName(getterName, getterObject);
    }

    public static <T> Object getValueDynamicallyThroughGetterName(String getterName, T getterObject) {
        ReflectionUtil.validateMethodName(getterName, "Getter");
        ReflectionUtil.validateObject(getterObject, "Getter object");
        Method getter = ReflectionUtil.findGetterMethod(getterName, getterObject);
        if (!Modifier.isPublic(getter.getModifiers())) {
            throw new ApiException("Getter method is not public: " + getterName);
        }
        try {
            return getter.invoke(getterObject, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new ApiException("Error invoking getter: " + getterName, e);
        }
    }

    public static <T, S> void setValueDynamicallyThroughSetterNameFromField(Field field, T dest, S value) {
        ReflectionUtil.validateField(field);
        ReflectionUtil.validateObject(dest, "Destination object");
        String setterName = "set" + StringUtils.capitalize((String)field.getName());
        ReflectionUtil.setValueDynamicallyThroughSetterName(setterName, dest, value);
    }

    public static <T, S> void setValueDynamicallyThroughSetterName(String setterName, T target, S valueToSet) {
        ReflectionUtil.validateMethodName(setterName, "Setter");
        ReflectionUtil.validateObject(target, "Target object");
        Method setter = ReflectionUtil.findSetterMethod(setterName, target);
        if (!Modifier.isPublic(setter.getModifiers())) {
            throw new ApiException("Setter method is not public: " + setterName);
        }
        Class<?> paramType = setter.getParameterTypes()[0];
        Class<?> valueType = valueToSet != null ? valueToSet.getClass() : null;
        try {
            ReflectionUtil.invokeSetterWithTypeConversion(setter, target, valueToSet, paramType, valueType);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new ApiException("Error invoking setter: " + setterName, e);
        }
    }

    private static <T, S> void invokeSetterWithTypeConversion(Method setter, T target, S valueToSet, Class<?> paramType, Class<?> valueType) throws IllegalAccessException, InvocationTargetException {
        Class wrapperType;
        if (valueToSet == null) {
            if (paramType.isPrimitive()) {
                Object defaultValue = ReflectionTypeUtil.defaultValueFor(paramType);
                setter.invoke(target, defaultValue);
                return;
            }
            setter.invoke(target, new Object[]{null});
            return;
        }
        if (paramType.isPrimitive() && (wrapperType = ClassUtils.primitiveToWrapper(paramType)).isAssignableFrom(valueType)) {
            setter.invoke(target, valueToSet);
            return;
        }
        if (valueType != null && (wrapperType = ClassUtils.primitiveToWrapper(valueType)).isAssignableFrom(paramType)) {
            setter.invoke(target, valueToSet);
            return;
        }
        if (valueType != null && paramType.isAssignableFrom(valueType)) {
            setter.invoke(target, valueToSet);
            return;
        }
        throw new ApiException(String.format("Incompatible parameter type for setter: expected %s but got %s", paramType.getName(), valueType != null ? valueType.getName() : "null"));
    }

    private static <T> Method findGetterMethod(String getterName, T getterObject) {
        List<Method> allGetters = ReflectionUtil.findGetMethods(getterObject);
        if (CollectionUtils.isEmpty(allGetters)) {
            throw new ApiException("There's no getter method in specified Object!");
        }
        Optional<Method> opGetter = allGetters.stream().filter(getter -> getter.getName().equalsIgnoreCase(getterName)).findAny();
        if (opGetter.isEmpty()) {
            throw new ApiException("There's no getter with specified name: " + getterName);
        }
        return opGetter.get();
    }

    private static <T> Method findSetterMethod(String setterName, T setterClass) {
        List<Method> allSetters = ReflectionUtil.findSetMethods(setterClass);
        if (CollectionUtils.isEmpty(allSetters)) {
            throw new ApiException("There's no setter method in specified Object!");
        }
        Optional<Method> opSetter = allSetters.stream().filter(setter -> setter.getName().equalsIgnoreCase(setterName)).findAny();
        if (opSetter.isEmpty()) {
            throw new ApiException("There's no setter with specified name: " + setterName);
        }
        return opSetter.get();
    }

    private static void validateObject(Object object, String description) {
        if (object == null) {
            throw new ApiException(description + " cannot be null");
        }
    }

    private static void validateField(Field field) {
        if (field == null) {
            throw new ApiException("Field cannot be null");
        }
    }

    private static void validateMethodName(String methodName, String description) {
        if (methodName == null || methodName.trim().isEmpty()) {
            throw new ApiException(description + " method name cannot be null or empty");
        }
    }

    private static <T, R> void validateGetter(Function<T, R> getter) {
        if (getter == null) {
            throw new ApiException("Getter function cannot be null");
        }
    }

    private static <T> void validateComparisonParameters(T entity1, T entity2) {
        if (entity1 == null || entity2 == null) {
            throw new ApiException(NULL_ENTITY_ERROR);
        }
        if (!entity1.getClass().equals(entity2.getClass())) {
            throw new ApiException(DIFFERENT_TYPES_ERROR);
        }
    }

    @Generated
    private ReflectionUtil() {
    }
}

