/*
 * Decompiled with CFR 0.152.
 */
package io.github.gregoryfeijon.object.factory.commons.utils.enums;

import io.github.gregoryfeijon.object.factory.commons.exception.ApiException;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import lombok.Generated;

public final class EnumUtil {
    private static final String NULL_ARGUMENTS_ERROR = "Arguments cannot be null: enumType, method, and expectedValue are required";

    public static <T extends Enum<T>, R> Optional<T> getEnum(Class<T> enumType, Function<T, R> method, R expectedValue) {
        EnumUtil.validateArguments(enumType, method, expectedValue);
        return EnumUtil.findMatchingEnum(enumType, method, expectedValue);
    }

    public static <T extends Enum<T>, R> T getEnumOrNull(Class<T> enumType, Function<T, R> method, R expectedValue) {
        if (EnumUtil.hasNullValues(enumType, method, expectedValue)) {
            return null;
        }
        return (T)((Enum)EnumUtil.findMatchingEnum(enumType, method, expectedValue).orElse(null));
    }

    private static <T extends Enum<T>, R> Optional<T> findMatchingEnum(Class<T> enumType, Function<T, R> method, R expectedValue) {
        return Stream.of((Enum[])enumType.getEnumConstants()).filter(enumConstant -> EnumUtil.isMatchingEnum(enumConstant, method, expectedValue)).findFirst();
    }

    private static <T extends Enum<T>, R> boolean isMatchingEnum(T enumConstant, Function<T, R> method, R expectedValue) {
        R value = method.apply(enumConstant);
        return value != null && value.equals(expectedValue);
    }

    private static <T extends Enum<T>, R> void validateArguments(Class<T> enumType, Function<T, R> method, R expectedValue) {
        if (EnumUtil.hasNullValues(enumType, method, expectedValue)) {
            throw new ApiException(NULL_ARGUMENTS_ERROR);
        }
    }

    private static <T extends Enum<T>, R> boolean hasNullValues(Class<T> enumType, Function<T, R> method, R expectedValue) {
        return enumType == null || method == null || expectedValue == null;
    }

    @Generated
    private EnumUtil() {
    }
}

