/*
 * Decompiled with CFR 0.152.
 */
package io.github.gregoryfeijon.object.factory.commons.utils.factory;

import io.github.gregoryfeijon.object.factory.commons.exception.ApiException;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@Component
public class FactoryUtil
implements ApplicationContextAware {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FactoryUtil.class);
    private static final AtomicReference<ApplicationContext> contextRef = new AtomicReference();
    private static final String CONTEXT_NOT_INITIALIZED = "ApplicationContext has not been initialized yet";

    public static <T> T getBean(Class<T> beanClass) {
        ApplicationContext context = FactoryUtil.getContext();
        FactoryUtil.validateBeanClass(beanClass);
        try {
            return (T)context.getBean(beanClass);
        }
        catch (BeansException e) {
            throw new ApiException("Failed to retrieve bean of type: " + beanClass.getName(), e);
        }
    }

    public static <T> T getBeanFromName(String beanName, Class<T> beanClass) {
        ApplicationContext context = FactoryUtil.getContext();
        FactoryUtil.validateBeanName(beanName);
        FactoryUtil.validateBeanClass(beanClass);
        try {
            return (T)context.getBean(beanName, beanClass);
        }
        catch (BeansException e) {
            throw new ApiException(String.format("Failed to retrieve bean with name '%s' and type: %s", beanName, beanClass.getName()), e);
        }
    }

    public void setApplicationContext(@NonNull ApplicationContext applicationContext) throws BeansException {
        boolean wasSet = contextRef.compareAndSet(null, applicationContext);
        if (!wasSet && contextRef.get() != applicationContext) {
            log.warn("Attempted to set a different ApplicationContext. Keeping the original.");
        }
    }

    private static ApplicationContext getContext() {
        ApplicationContext context = contextRef.get();
        if (context == null) {
            throw new ApiException(CONTEXT_NOT_INITIALIZED);
        }
        return context;
    }

    private static <T> void validateBeanClass(Class<T> beanClass) {
        if (beanClass == null) {
            throw new ApiException("Bean class cannot be null");
        }
    }

    private static void validateBeanName(String beanName) {
        if (beanName == null || beanName.trim().isEmpty()) {
            throw new ApiException("Bean name cannot be null or empty");
        }
    }
}

